/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.AbstractFlowConstuctTestCase;
import org.mule.construct.Validator;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.tck.MuleTestUtils;

public class ValidatorTestCase
extends AbstractFlowConstuctTestCase {
    private Validator validator;
    protected Connector testConnector;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        OutboundEndpoint testOutboundEndpoint = MuleTestUtils.getTestOutboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        this.testConnector = testOutboundEndpoint.getConnector();
        muleContext.getRegistry().registerConnector(this.testConnector);
        this.testConnector.start();
        this.validator = new Validator("test-validator", muleContext, (MessageSource)this.directInboundMessageSource, testOutboundEndpoint, (Filter)new PayloadTypeFilter(Integer.class), "#[string:GOOD:#[message:payload]]", "#[string:BAD:#[message:payload]]");
    }

    protected AbstractFlowConstruct getFlowConstruct() throws Exception {
        return this.validator;
    }

    public void testAck() throws Exception {
        this.validator.initialise();
        this.validator.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestInboundEvent(123, muleContext));
        ValidatorTestCase.assertEquals((String)"GOOD:123", (String)response.getMessageAsString());
    }

    public void testNack() throws Exception {
        this.validator.initialise();
        this.validator.start();
        MuleEvent response = this.directInboundMessageSource.process(MuleTestUtils.getTestInboundEvent("abc", muleContext));
        ValidatorTestCase.assertEquals((String)"BAD:abc", (String)response.getMessageAsString());
    }
}

