/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import java.util.ArrayList;
import junit.framework.Assert;
import org.mule.api.MuleEvent;
import org.mule.api.component.Component;
import org.mule.api.service.Service;
import org.mule.component.AbstractComponent;
import org.mule.interceptor.AbstractEnvelopeInterceptor;
import org.mule.interceptor.InterceptorStack;
import org.mule.model.seda.SedaService;
import org.mule.tck.AbstractMuleTestCase;

public class InterceptorTestCase
extends AbstractMuleTestCase {
    private final String BEFORE = "Before";
    private final String AFTER = "After";
    private final String COMPONENT = "component";
    private final String INTERCEPTOR_ONE = "inteceptor1";
    private final String INTERCEPTOR_TWO = "inteceptor2";
    private final String INTERCEPTOR_THREE = "inteceptor3";
    private final String SINGLE_INTERCEPTOR_RESULT = "inteceptor1Beforecomponentinteceptor1After";
    private final String MULTIPLE_INTERCEPTOR_RESULT = "inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After";

    public void testSingleInterceptor() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforecomponentinteceptor1After", (String)result.getMessageAsString());
    }

    public void testMultipleInterceptor() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (String)result.getMessageAsString());
    }

    public void testSingleInterceptorStack() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<InterceptorStack> interceptors = new ArrayList<InterceptorStack>();
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforecomponentinteceptor1After", (String)result.getMessageAsString());
    }

    public void testMultipleInterceptorStack() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1After", (String)result.getMessageAsString());
    }

    public void testMultipleInterceptorStack2() throws Exception {
        Service service = this.createUninitializedService();
        TestComponent component = (TestComponent)service.getComponent();
        ArrayList<TestInterceptor> interceptors = new ArrayList<TestInterceptor>();
        interceptors.add(new TestInterceptor("inteceptor1"));
        interceptors.add(new TestInterceptor("inteceptor2"));
        interceptors.add(new TestInterceptor("inteceptor3"));
        ArrayList<TestInterceptor> stackInterceptors = new ArrayList<TestInterceptor>();
        stackInterceptors.add(new TestInterceptor("inteceptor1"));
        stackInterceptors.add(new TestInterceptor("inteceptor2"));
        stackInterceptors.add(new TestInterceptor("inteceptor3"));
        interceptors.add((TestInterceptor)new InterceptorStack(stackInterceptors));
        component.setInterceptors(interceptors);
        service.initialise();
        service.start();
        MuleEvent result = component.process(InterceptorTestCase.getTestInboundEvent(""));
        InterceptorTestCase.assertEquals((String)"inteceptor1Beforeinteceptor2Beforeinteceptor3Beforeinteceptor1Beforeinteceptor2Beforeinteceptor3Beforecomponentinteceptor3Afterinteceptor2Afterinteceptor1Afterinteceptor3Afterinteceptor2Afterinteceptor1After", (String)result.getMessageAsString());
    }

    protected Service createUninitializedService() throws Exception {
        TestComponent component = new TestComponent();
        SedaService service = new SedaService(muleContext);
        service.setName("name");
        service.setComponent((Component)component);
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        return service;
    }

    class TestComponent
    extends AbstractComponent {
        TestComponent() {
        }

        protected Object doInvoke(MuleEvent event) throws Exception {
            return event.getMessageAsString() + "component";
        }
    }

    class TestInterceptor
    extends AbstractEnvelopeInterceptor {
        private String name;

        public TestInterceptor(String name) {
            this.name = name;
        }

        public MuleEvent after(MuleEvent event) {
            try {
                event.getMessage().setPayload((Object)(event.getMessage().getPayloadAsString() + this.name + "After"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            return event;
        }

        public MuleEvent before(MuleEvent event) {
            try {
                event.getMessage().setPayload((Object)(event.getMessage().getPayloadAsString() + this.name + "Before"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            return event;
        }
    }
}

