/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.api.transport.PropertyScope;
import org.mule.model.resolvers.MethodHeaderPropertyEntryPointResolver;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.transport.NullPayload;

public class MethodHeaderEntryPointResolverTestCase
extends AbstractMuleTestCase {
    public void testMethodSetPass() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("method", (Object)"someBusinessMethod", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testMethodSetWithNoArgsPass() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance());
        ctx.getMessage().setProperty("method", (Object)"wash", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new Apple(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        MethodHeaderEntryPointResolverTestCase.assertEquals((String)"wash", (String)result.getMethodCalled());
    }

    public void testCustomMethodProperty() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("serviceMethod", (Object)"someBusinessMethod", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testCustomMethodPropertyFail() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("serviceMethod", (Object)"noMethod", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    public void testMethodPropertyFail() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("myMethod", (Object)"someBusinessMethod", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    public void testMethodPropertyMismatch() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("method", (Object)"noMethod", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    public void testMethodPropertyParameterAssignableFromPayload() throws Exception {
        MethodHeaderPropertyEntryPointResolver resolver = new MethodHeaderPropertyEntryPointResolver();
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext(new Apple());
        ctx.getMessage().setProperty("method", (Object)"wash", PropertyScope.INBOUND);
        InvocationResult result = resolver.invoke((Object)new TestFruitCleaner(), ctx);
        MethodHeaderEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public static class TestFruitCleaner {
        public void wash(Fruit fruit) {
        }

        public void polish(Fruit fruit) {
        }
    }
}

