/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.EqualsFilter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.SensingNullMessageProcessor;

public class MessageFilterTestCase
extends AbstractMuleTestCase {
    @Test
    public void testFilterPass() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter((Object)"Test Message"), false, null);
        SensingNullMessageProcessor listener = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)listener);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent("Test Message");
        MuleEvent resultEvent = mp.process(inEvent);
        MessageFilterTestCase.assertNotNull((Object)listener.event);
        MessageFilterTestCase.assertSame((Object)inEvent, (Object)listener.event);
        MessageFilterTestCase.assertEquals((Object)inEvent, (Object)resultEvent);
    }

    @Test
    public void testFilterFail() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter(null), false, null);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)out);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent("Test Message");
        MuleEvent resultEvent = mp.process(inEvent);
        MessageFilterTestCase.assertNull((Object)out.event);
        MessageFilterTestCase.assertNull((Object)resultEvent);
    }

    @Test
    public void testFilterPassUnacceptedMP() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter((Object)"Test Message"), false, null);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        SensingNullMessageProcessor unaccepted = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)out);
        mp.setUnacceptedMessageProcessor((MessageProcessor)unaccepted);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent("Test Message");
        MuleEvent resultEvent = mp.process(inEvent);
        MessageFilterTestCase.assertNotNull((Object)out.event);
        MessageFilterTestCase.assertSame((Object)inEvent, (Object)out.event);
        MessageFilterTestCase.assertEquals((Object)inEvent, (Object)resultEvent);
        MessageFilterTestCase.assertNull((Object)unaccepted.event);
    }

    @Test
    public void testFilterFailUnacceptedMP() throws Exception {
        SensingNullMessageProcessor unaccepted = this.getSensingNullMessageProcessor();
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter(null), false, (MessageProcessor)unaccepted);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)out);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent((Object)"Test Message", MessageExchangePattern.ONE_WAY);
        MuleEvent resultEvent = mp.process(inEvent);
        MessageFilterTestCase.assertNull((Object)out.event);
        MessageFilterTestCase.assertNull((Object)resultEvent);
        MessageFilterTestCase.assertNotNull((Object)unaccepted.event);
        MessageFilterTestCase.assertSame((Object)inEvent, (Object)unaccepted.event);
    }
}

