/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.ExceptionUtils;

public class ExceptionUtilsTestCase
extends AbstractMuleTestCase {
    public void testContainsType() {
        ExceptionUtilsTestCase.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new IllegalArgumentException(), IllegalArgumentException.class));
        ExceptionUtilsTestCase.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException()), IllegalArgumentException.class));
        ExceptionUtilsTestCase.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), NullPointerException.class));
        ExceptionUtilsTestCase.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), RuntimeException.class));
        ExceptionUtilsTestCase.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), Exception.class));
        ExceptionUtilsTestCase.assertFalse((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), IOException.class));
    }

    public void testLastIndexOfType_deepestIsTheOneWeWant() throws Exception {
        IllegalArgumentException expected = new IllegalArgumentException("something");
        this.assertExpectationsForDeepestOccurence(expected);
    }

    public void testLastIndexOfType_theOneWeWantIsNotTheDeepest() throws Exception {
        IllegalArgumentException expected = new IllegalArgumentException("something", new NullPointerException("somenull"));
        this.assertExpectationsForDeepestOccurence(expected);
    }

    private void assertExpectationsForDeepestOccurence(IllegalArgumentException expected) {
        ExceptionUtilsTestCase.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)expected, IllegalArgumentException.class));
        ExceptionUtilsTestCase.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new Exception(expected), IllegalArgumentException.class));
        ExceptionUtilsTestCase.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new IllegalArgumentException(new Exception(expected)), IllegalArgumentException.class));
        ExceptionUtilsTestCase.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new IllegalArgumentException(new Exception(expected)), IOException.class));
    }

    public void testLastIndexOfType_nullParameters() throws Exception {
        ExceptionUtilsTestCase.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType(null, null));
        ExceptionUtilsTestCase.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new Exception(), null));
        ExceptionUtilsTestCase.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType(null, Exception.class));
    }
}

