/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.MapUtils;
import org.mule.util.SystemUtils;

public class MapUtilsTestCase
extends AbstractMuleTestCase {
    public void testMapCreationNullClass() {
        try {
            MapUtils.mapWithKeysAndValues(null, (Object[])null, (Object[])null);
            MapUtilsTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMapCreationWithoutElements() {
        Map m = MapUtils.mapWithKeysAndValues(HashMap.class, (Collection)null, (Collection)null);
        MapUtilsTestCase.assertTrue((boolean)m.isEmpty());
    }

    public void testCaseInsensitiveMapCreation() {
        List<String> strings = Arrays.asList("foo");
        Map m = MapUtils.mapWithKeysAndValues(CaseInsensitiveMap.class, strings.iterator(), strings.iterator());
        MapUtilsTestCase.assertEquals((Object)"foo", m.get("foo"));
        MapUtilsTestCase.assertEquals((Object)"foo", m.get("Foo"));
        MapUtilsTestCase.assertEquals((Object)"foo", m.get("FOO"));
    }

    public void testToStringNull() throws Exception {
        Map props = null;
        MapUtilsTestCase.assertEquals((String)"{}", (String)MapUtils.toString(props, (boolean)false));
        MapUtilsTestCase.assertEquals((String)"{}", (String)MapUtils.toString(props, (boolean)true));
    }

    public void testToStringEmpty() throws Exception {
        HashMap props = new HashMap();
        MapUtilsTestCase.assertEquals((String)"{}", (String)MapUtils.toString(props, (boolean)false));
        MapUtilsTestCase.assertEquals((String)"{}", (String)MapUtils.toString(props, (boolean)true));
    }

    public void testToStringSingleElement() throws Exception {
        Map props = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new Object[]{"foo"}, (Object[])new Object[]{"bar"});
        MapUtilsTestCase.assertEquals((String)"{foo=bar}", (String)MapUtils.toString((Map)props, (boolean)false));
        MapUtilsTestCase.assertEquals((String)("{" + SystemUtils.LINE_SEPARATOR + "foo=bar" + SystemUtils.LINE_SEPARATOR + "}"), (String)MapUtils.toString((Map)props, (boolean)true));
    }

    public void testToStringMultipleElements() throws Exception {
        Map props = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new Object[]{"foo", "foozle"}, (Object[])new Object[]{"bar", "doozle"});
        String result = MapUtils.toString((Map)props, (boolean)false);
        MapUtilsTestCase.assertTrue((result.indexOf("foo=bar") != -1 ? 1 : 0) != 0);
        MapUtilsTestCase.assertTrue((result.indexOf("foozle=doozle") != -1 ? 1 : 0) != 0);
        result = MapUtils.toString((Map)props, (boolean)true);
        MapUtilsTestCase.assertTrue((boolean)result.startsWith("{" + SystemUtils.LINE_SEPARATOR));
        MapUtilsTestCase.assertTrue((result.indexOf("foo=bar") != -1 ? 1 : 0) != 0);
        MapUtilsTestCase.assertTrue((result.indexOf("foozle=doozle") != -1 ? 1 : 0) != 0);
        MapUtilsTestCase.assertTrue((boolean)result.endsWith(SystemUtils.LINE_SEPARATOR + "}"));
    }
}

