/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.WaitableBoolean;

public class WaitableBooleanTestCase
extends AbstractMuleTestCase {
    protected final WaitableBoolean TRUE = new WaitableBoolean(true);
    protected final WaitableBoolean FALSE = new WaitableBoolean(false);

    public void testCompareToBoolean() {
        WaitableBooleanTestCase.assertEquals((int)0, (int)this.TRUE.compareTo(true));
        WaitableBooleanTestCase.assertEquals((int)1, (int)this.TRUE.compareTo(false));
        WaitableBooleanTestCase.assertEquals((int)0, (int)this.FALSE.compareTo(false));
        WaitableBooleanTestCase.assertEquals((int)-1, (int)this.FALSE.compareTo(true));
    }

    public void testCompareToWaitableBoolean() {
        WaitableBooleanTestCase.assertEquals((int)0, (int)this.TRUE.compareTo(new WaitableBoolean(true)));
        WaitableBooleanTestCase.assertEquals((int)1, (int)this.TRUE.compareTo(new WaitableBoolean(false)));
        WaitableBooleanTestCase.assertEquals((int)0, (int)this.FALSE.compareTo(new WaitableBoolean(false)));
        WaitableBooleanTestCase.assertEquals((int)-1, (int)this.FALSE.compareTo(new WaitableBoolean(true)));
        WaitableBooleanTestCase.assertEquals((int)0, (int)this.TRUE.compareTo((Object)this.TRUE));
    }

    public void testCompareToObject() {
        WaitableBooleanTestCase.assertEquals((int)0, (int)this.TRUE.compareTo((Object)this.TRUE));
    }

    public void testEquals() {
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.equals((Object)this.TRUE));
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.equals((Object)this.FALSE));
        WaitableBooleanTestCase.assertFalse((boolean)this.FALSE.equals((Object)this.TRUE));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.equals((Object)new WaitableBoolean(true)));
        WaitableBooleanTestCase.assertTrue((boolean)this.FALSE.equals((Object)new WaitableBoolean(false)));
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.equals((Object)":-)"));
    }

    public void testHashCode() {
        WaitableBooleanTestCase.assertTrue((this.TRUE.hashCode() != this.FALSE.hashCode() ? 1 : 0) != 0);
        WaitableBooleanTestCase.assertEquals((int)this.TRUE.hashCode(), (int)new WaitableBoolean(true).hashCode());
        WaitableBooleanTestCase.assertEquals((int)this.FALSE.hashCode(), (int)new WaitableBoolean(false).hashCode());
    }

    public void testToString() {
        WaitableBooleanTestCase.assertEquals((String)"true", (String)this.TRUE.toString());
        WaitableBooleanTestCase.assertEquals((String)"false", (String)this.FALSE.toString());
    }

    public void testGet() {
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.get());
        WaitableBooleanTestCase.assertFalse((boolean)this.FALSE.get());
    }

    public void testSet() {
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.set(true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.set(false));
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.set(true));
        WaitableBooleanTestCase.assertFalse((boolean)this.FALSE.set(false));
        WaitableBooleanTestCase.assertFalse((boolean)this.FALSE.set(true));
        WaitableBooleanTestCase.assertTrue((boolean)this.FALSE.set(true));
    }

    public void testCommit() {
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.compareAndSet(true, true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.get());
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.compareAndSet(false, true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.compareAndSet(true, false));
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.get());
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.compareAndSet(false, true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.get());
    }

    public void testComplement() {
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.complement());
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.get());
        WaitableBooleanTestCase.assertTrue((boolean)this.FALSE.complement());
        WaitableBooleanTestCase.assertTrue((boolean)this.FALSE.get());
    }

    public void testAnd() {
        WaitableBooleanTestCase.assertTrue((boolean)new WaitableBoolean(true).and(true));
        WaitableBooleanTestCase.assertFalse((boolean)new WaitableBoolean(true).and(false));
        WaitableBooleanTestCase.assertFalse((boolean)new WaitableBoolean(false).and(false));
        WaitableBooleanTestCase.assertFalse((boolean)new WaitableBoolean(false).and(true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.and(true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.get());
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.and(false));
        WaitableBooleanTestCase.assertFalse((boolean)this.TRUE.get());
    }

    public void testOr() {
        WaitableBooleanTestCase.assertTrue((boolean)new WaitableBoolean(true).or(true));
        WaitableBooleanTestCase.assertTrue((boolean)new WaitableBoolean(true).or(false));
        WaitableBooleanTestCase.assertFalse((boolean)new WaitableBoolean(false).or(false));
        WaitableBooleanTestCase.assertTrue((boolean)new WaitableBoolean(false).or(true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.or(true));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.get());
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.or(false));
        WaitableBooleanTestCase.assertTrue((boolean)this.TRUE.get());
    }

    public void testXor() {
        WaitableBooleanTestCase.assertFalse((boolean)new WaitableBoolean(true).xor(true));
        WaitableBooleanTestCase.assertTrue((boolean)new WaitableBoolean(true).xor(false));
        WaitableBooleanTestCase.assertFalse((boolean)new WaitableBoolean(false).xor(false));
        WaitableBooleanTestCase.assertTrue((boolean)new WaitableBoolean(false).xor(true));
    }

    public void testWhenFalse() throws InterruptedException {
        final WaitableBoolean blocker = new WaitableBoolean(true);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable switcher = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                    blocker.set(false);
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(iex);
                }
            }
        };
        Runnable action = new Runnable(){

            public void run() {
                actionPerformed.set(true);
            }
        };
        new Thread(switcher).start();
        blocker.whenFalse(action);
        WaitableBooleanTestCase.assertFalse((boolean)blocker.get());
        WaitableBooleanTestCase.assertTrue((boolean)actionPerformed.get());
    }

    public void testWhenFalseAlreadyFalse() throws InterruptedException {
        WaitableBoolean blocker = new WaitableBoolean(false);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable action = new Runnable(){

            public void run() {
                actionPerformed.set(true);
            }
        };
        blocker.whenFalse(action);
        WaitableBooleanTestCase.assertFalse((boolean)blocker.get());
        WaitableBooleanTestCase.assertTrue((boolean)actionPerformed.get());
    }

    public void testWhenTrue() throws InterruptedException {
        final WaitableBoolean blocker = new WaitableBoolean(false);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable switcher = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                    blocker.set(true);
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(iex);
                }
            }
        };
        Runnable action = new Runnable(){

            public void run() {
                actionPerformed.set(true);
            }
        };
        new Thread(switcher).start();
        blocker.whenTrue(action);
        WaitableBooleanTestCase.assertTrue((boolean)blocker.get());
        WaitableBooleanTestCase.assertTrue((boolean)actionPerformed.get());
    }

    public void testWhenTrueAlreadyTrue() throws InterruptedException {
        WaitableBoolean blocker = new WaitableBoolean(true);
        final WaitableBoolean actionPerformed = new WaitableBoolean(false);
        Runnable action = new Runnable(){

            public void run() {
                actionPerformed.set(true);
            }
        };
        blocker.whenTrue(action);
        WaitableBooleanTestCase.assertTrue((boolean)blocker.get());
        WaitableBooleanTestCase.assertTrue((boolean)actionPerformed.get());
    }

    public void testGetLock() {
        WaitableBoolean b = new WaitableBoolean(true);
        WaitableBooleanTestCase.assertSame((Object)b, (Object)b.getLock());
        b = new WaitableBoolean(true, (Object)this);
        WaitableBooleanTestCase.assertSame((Object)this, (Object)b.getLock());
    }
}

