/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.generics;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.generics.GenericBean;
import org.mule.util.generics.GenericsUtils;
import org.mule.util.generics.MethodParameter;

public class GenericsUtilsTestCase
extends AbstractMuleTestCase {
    protected Class<?> targetClass;
    protected String[] methods;
    protected Type[] expectedResults;

    protected void doSetUp() throws Exception {
        this.targetClass = Foo.class;
        this.methods = new String[]{"a", "b", "b2", "b3", "c", "d", "d2", "d3", "e", "e2", "e3"};
        this.expectedResults = new Class[]{Integer.class, null, Set.class, Set.class, null, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class};
    }

    protected Type getType(Method method) {
        return GenericsUtils.getMapValueReturnType((Method)method);
    }

    public void testA() throws Exception {
        this.executeTest();
    }

    public void testB() throws Exception {
        this.executeTest();
    }

    public void testB2() throws Exception {
        this.executeTest();
    }

    public void testB3() throws Exception {
        this.executeTest();
    }

    public void testC() throws Exception {
        this.executeTest();
    }

    public void testD() throws Exception {
        this.executeTest();
    }

    public void testD2() throws Exception {
        this.executeTest();
    }

    public void testD3() throws Exception {
        this.executeTest();
    }

    public void testE() throws Exception {
        this.executeTest();
    }

    public void testE2() throws Exception {
        this.executeTest();
    }

    public void testE3() throws Exception {
        this.executeTest();
    }

    public void testProgrammaticListIntrospection() throws Exception {
        Method setter = GenericBean.class.getMethod("setResourceList", List.class);
        GenericsUtilsTestCase.assertEquals(String.class, (Object)GenericsUtils.getCollectionParameterType((MethodParameter)new MethodParameter(setter, 0)));
        Method getter = GenericBean.class.getMethod("getResourceList", new Class[0]);
        GenericsUtilsTestCase.assertEquals(String.class, (Object)GenericsUtils.getCollectionReturnType((Method)getter));
    }

    protected void executeTest() throws NoSuchMethodException {
        String methodName = this.getName().trim().replaceFirst("test", "").toLowerCase();
        for (int i = 0; i < this.methods.length; ++i) {
            if (!methodName.equals(this.methods[i])) continue;
            Method method = this.targetClass.getMethod(methodName, new Class[0]);
            Type type = this.getType(method);
            GenericsUtilsTestCase.assertEquals((Object)this.expectedResults[i], (Object)type);
            return;
        }
        throw new IllegalStateException("Bad test data");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Foo {
        public Map<String, Integer> a();

        public Map<?, ?> b();

        public Map<?, ? extends Set> b2();

        public Map<?, ? super Set> b3();

        public Map c();

        public CustomMap<Date> d();

        public CustomMap<?> d2();

        public CustomMap d3();

        public OtherCustomMap<Date> e();

        public OtherCustomMap<?> e2();

        public OtherCustomMap e3();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class OtherCustomMap<T>
    implements Map<String, Integer> {
        private OtherCustomMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CustomMap<T>
    extends AbstractMap<String, Integer> {
        private CustomMap() {
        }
    }
}

