/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.config.builders.AutoConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.launcher.AbstractFileWatcher;
import org.mule.module.launcher.Application;
import org.mule.module.launcher.ApplicationMuleContextBuilder;
import org.mule.module.launcher.ConfigChangeMonitorThreadFactory;
import org.mule.module.launcher.DefaultAppBloodhound;
import org.mule.module.launcher.DefaultMuleSharedDomainClassLoader;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.DeploymentStopException;
import org.mule.module.launcher.InstallException;
import org.mule.module.launcher.MuleApplicationClassLoader;
import org.mule.module.launcher.MuleSharedDomainClassLoader;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;

public class DefaultMuleApplication
implements Application {
    protected static final int DEFAULT_RELOAD_CHECK_INTERVAL_MS = 3000;
    protected static final String ANCHOR_FILE_BLURB = "Delete this file while Mule is running to undeploy this app in a clean way.";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected ScheduledExecutorService watchTimer;
    private String appName;
    private MuleContext muleContext;
    private ClassLoader deploymentClassLoader;
    protected ApplicationDescriptor descriptor;
    protected String[] absoluteResourcePaths;

    public DefaultMuleApplication(String appName) {
        this.appName = appName;
    }

    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Installing application: " + this.appName));
        }
        DefaultAppBloodhound bh = new DefaultAppBloodhound();
        try {
            this.descriptor = bh.fetch(this.getAppName());
        }
        catch (IOException e) {
            throw new InstallException(MessageFactory.createStaticMessage("Failed to parse the application deployment descriptor"), (Throwable)e);
        }
        String[] configResources = this.descriptor.getConfigResources();
        this.absoluteResourcePaths = new String[configResources.length];
        for (int i = 0; i < configResources.length; ++i) {
            String resource = configResources[i];
            File file = this.toAbsoluteFile(resource);
            if (!file.exists()) {
                throw new InstallException(MessageFactory.createStaticMessage(String.format("Config for app '%s' not found: %s", this.getAppName(), file)));
            }
            this.absoluteResourcePaths[i] = file.getAbsolutePath();
        }
        this.createDeploymentClassLoader();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting application: " + this.appName));
        }
        try {
            this.muleContext.start();
            File marker = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), String.format("%s-anchor.txt", this.getAppName()));
            FileUtils.writeStringToFile((File)marker, (String)ANCHOR_FILE_BLURB);
        }
        catch (MuleException e) {
            throw new DeploymentStartException(MessageFactory.createStaticMessage(this.appName), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentStartException(MessageFactory.createStaticMessage(this.appName), (Throwable)e);
        }
    }

    public void init() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initializing application: " + this.appName));
        }
        String configBuilderClassName = null;
        try {
            String builderFromDesc = this.descriptor.getConfigurationBuilder();
            configBuilderClassName = "spring".equalsIgnoreCase(builderFromDesc) ? "org.mule.config.spring.SpringXmlConfigurationBuilder" : (builderFromDesc == null ? AutoConfigurationBuilder.class.getName() : builderFromDesc);
            ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)ClassUtils.instanciateClass(configBuilderClassName, new Object[]{this.absoluteResourcePaths}, this.getDeploymentClassLoader());
            if (!cfgBuilder.isConfigured()) {
                ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>(2);
                Map<String, String> appProperties = this.descriptor.getAppProperties();
                appProperties.put("app.home", new File(MuleContainerBootstrapUtils.getMuleAppsDir(), this.getAppName()).getAbsolutePath());
                builders.add(new SimpleConfigurationBuilder(appProperties));
                if (ClassUtils.isClassOnPath("org.mule.config.AnnotationsConfigurationBuilder", this.getClass())) {
                    Object configBuilder = ClassUtils.instanciateClass("org.mule.config.AnnotationsConfigurationBuilder", ClassUtils.NO_ARGS, this.getClass());
                    builders.add((ConfigurationBuilder)configBuilder);
                }
                builders.add(cfgBuilder);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                this.muleContext = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)new ApplicationMuleContextBuilder(this.descriptor));
                if (this.descriptor.isRedeploymentEnabled()) {
                    this.createRedeployMonitor();
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentInitException(CoreMessages.failedToLoad(configBuilderClassName), (Throwable)e);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public ClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    public void dispose() {
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"MuleContext not created, nothing to dispose of");
            }
            return;
        }
        if (this.muleContext.isStarted() && !this.muleContext.isDisposed()) {
            this.stop();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing application: " + this.appName));
        }
        this.muleContext.dispose();
        this.muleContext = null;
        Thread.currentThread().setContextClassLoader(null);
    }

    public void redeploy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Redeploying application: " + this.appName));
        }
        this.dispose();
        this.install();
        ClassLoader cl = this.getDeploymentClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        this.init();
        this.start();
        Thread.currentThread().setContextClassLoader(null);
    }

    public void stop() {
        if (this.muleContext == null) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping application: " + this.appName));
        }
        try {
            this.muleContext.stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(MessageFactory.createStaticMessage(this.appName), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.appName, Integer.toHexString(System.identityHashCode(this)));
    }

    protected void createDeploymentClassLoader() {
        String domain = this.descriptor.getDomain();
        MuleSharedDomainClassLoader parent = StringUtils.isBlank((String)domain) || "default".equals(domain) ? new DefaultMuleSharedDomainClassLoader(this.getClass().getClassLoader()) : new MuleSharedDomainClassLoader(domain, this.getClass().getClassLoader());
        this.deploymentClassLoader = new MuleApplicationClassLoader(this.appName, (ClassLoader)parent);
    }

    protected void createRedeployMonitor() throws NotificationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Monitoring for hot-deployment: " + new File(this.absoluteResourcePaths[0])));
        }
        final ConfigFileWatcher watcher = new ConfigFileWatcher(new File(this.absoluteResourcePaths[0]));
        this.muleContext.registerListener(new MuleContextNotificationListener<MuleContextNotification>(){

            @Override
            public void onNotification(MuleContextNotification notification) {
                int action = notification.getAction();
                switch (action) {
                    case 104: {
                        DefaultMuleApplication.this.scheduleConfigMonitor(watcher);
                        break;
                    }
                    case 105: {
                        DefaultMuleApplication.this.watchTimer.shutdownNow();
                        DefaultMuleApplication.this.muleContext.unregisterListener(this);
                    }
                }
            }
        });
    }

    protected void scheduleConfigMonitor(AbstractFileWatcher watcher) {
        int reloadIntervalMs = 3000;
        this.watchTimer = Executors.newSingleThreadScheduledExecutor(new ConfigChangeMonitorThreadFactory(this.appName));
        this.watchTimer.scheduleWithFixedDelay(watcher, 3000L, 3000L, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Reload interval: 3000");
        }
    }

    protected File toAbsoluteFile(String path) {
        String muleHome = System.getProperty("mule.home");
        String configPath = String.format("%s/apps/%s/%s", muleHome, this.getAppName(), path);
        return new File(configPath);
    }

    protected class ConfigFileWatcher
    extends AbstractFileWatcher {
        public ConfigFileWatcher(File watchedResource) {
            super(watchedResource);
        }

        protected synchronized void onChange(File file) {
            if (DefaultMuleApplication.this.logger.isInfoEnabled()) {
                DefaultMuleApplication.this.logger.info((Object)("================== Reloading " + file));
            }
            ClassLoader cl = DefaultMuleApplication.this.getDeploymentClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            DefaultMuleApplication.this.redeploy();
        }
    }
}

