/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.encoders;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL {
    private static final String UTF8 = "UTF-8";
    private static final String URL_SPACE_ENCODING = "+";
    private static final String OAUTH_SPEC_SPACE_ENCODING = "%20";

    public static String percentEncode(String string) {
        try {
            return URLEncoder.encode(string, UTF8).replace(URL_SPACE_ENCODING, OAUTH_SPEC_SPACE_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding: UTF-8");
        }
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unsupported encoding: UTF-8");
        }
    }

    public static String queryString(Map<String, String> params) {
        return params.size() <= 0 ? "" : "?" + URL.getFormEncodedString(params);
    }

    private static String getFormEncodedString(Map<String, String> params) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            buffer.append(URL.percentEncode(entry.getKey())).append('=').append(URL.percentEncode(entry.getValue())).append('&');
        }
        String query = buffer.toString();
        return query.substring(0, query.length() - 1);
    }
}

