/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.scribe.encoders.MD5;
import org.scribe.encoders.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OAuthParameters {
    Map<String, String> params = new HashMap<String, String>();

    public OAuthParameters(String consumerKey) {
        this.initDefaultParams(consumerKey);
    }

    private void initDefaultParams(String consumerKey) {
        this.params.put("oauth_timestamp", this.getTimestampInSeconds());
        this.params.put("oauth_signature_method", "HMAC-SHA1");
        this.params.put("oauth_version", "1.0");
        this.params.put("oauth_nonce", MD5.hexHash(this.getTimestampInSeconds() + new Random().nextInt()));
        this.params.put("oauth_consumer_key", consumerKey);
    }

    String getTimestampInSeconds() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public String asSortedFormEncodedString() {
        StringBuffer buffer = new StringBuffer();
        for (String key : this.sortedKeys()) {
            buffer.append(URL.percentEncode(key)).append('=').append(URL.percentEncode(this.params.get(key))).append('&');
        }
        return this.removeLast(buffer, "&");
    }

    private List<String> sortedKeys() {
        LinkedList<String> keys = new LinkedList<String>(this.params.keySet());
        Collections.sort(keys);
        return keys;
    }

    private String removeLast(StringBuffer buffer, String tail) {
        String result = buffer.toString();
        return result.substring(0, result.length() - tail.length());
    }

    public String asOAuthHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OAuth ");
        for (String key : this.sortedKeys()) {
            if (!key.startsWith("oauth_")) continue;
            buffer.append(key).append('=').append('\"').append(URL.percentEncode(this.params.get(key))).append("\", ");
        }
        return this.removeLast(buffer, ", ");
    }

    public void put(String key, String value) {
        this.params.put(key, value);
    }
}

