/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import java.util.Map;
import org.scribe.encoders.HMAC;
import org.scribe.encoders.URL;
import org.scribe.eq.DefaultEqualizer;
import org.scribe.http.Request;
import org.scribe.oauth.CallType;
import org.scribe.oauth.OAuthParameters;
import org.scribe.oauth.Token;

class OAuthSigner {
    private final String consumerSecret;
    private final OAuthParameters params;
    private final DefaultEqualizer eq;

    public OAuthSigner(String consumerKey, String consumerSecret, DefaultEqualizer eq) {
        this.consumerSecret = consumerSecret;
        this.eq = eq;
        this.params = new OAuthParameters(consumerKey);
    }

    public void signForRequestToken(Request request, String callback) {
        this.params.put("oauth_callback", callback);
        String toSign = this.getStringToSign(request, CallType.REQUEST_TOKEN);
        String oAuthHeader = this.getOAuthHeader(request, toSign, "", CallType.REQUEST_TOKEN);
        request.addHeader("Authorization", oAuthHeader);
    }

    public void signForAccessToken(Request request, Token requestToken, String verifier) {
        this.params.put("oauth_token", requestToken.getToken());
        this.params.put("oauth_verifier", verifier);
        String toSign = this.getStringToSign(request, CallType.ACCESS_TOKEN);
        String oAuthHeader = this.getOAuthHeader(request, toSign, requestToken.getSecret(), CallType.ACCESS_TOKEN);
        request.addHeader("Authorization", oAuthHeader);
    }

    public void sign(Request request, Token accessToken) {
        this.params.put("oauth_token", accessToken.getToken());
        String toSign = this.getStringToSign(request, CallType.RESOURCE);
        String oAuthHeader = this.getOAuthHeader(request, toSign, accessToken.getSecret(), CallType.RESOURCE);
        request.addHeader("Authorization", oAuthHeader);
    }

    public String getOAuthHeader(Request request, String toSign, String tokenSecret, CallType type) {
        String signature = this.getSignature(toSign, tokenSecret);
        this.params.put("oauth_signature", signature);
        return this.eq.tuneOAuthHeader(request, this.params.asOAuthHeader(), type);
    }

    public String getSignature(String toSign, String tokenSecret) {
        return HMAC.sign(toSign, URL.percentEncode(this.consumerSecret) + '&' + URL.percentEncode(tokenSecret));
    }

    public String getStringToSign(Request request, CallType type) {
        String verb = URL.percentEncode(request.getVerb().name());
        String url = URL.percentEncode(request.getSanitizedUrl());
        this.addQueryStringParams(request);
        this.addBodyParams(request);
        String sortedParams = URL.percentEncode(this.params.asSortedFormEncodedString());
        return this.eq.tuneStringToSign(request, String.format("%s&%s&%s", verb, url, sortedParams), type);
    }

    private void addQueryStringParams(Request request) {
        for (Map.Entry<String, String> entry : request.getQueryStringParams()) {
            this.params.put(entry.getKey(), entry.getValue());
        }
    }

    private void addBodyParams(Request request) {
        for (Map.Entry<String, String> entry : request.getBodyParams()) {
            this.params.put(entry.getKey(), entry.getValue());
        }
    }
}

