/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import java.util.Map;
import org.scribe.http.Request;
import org.scribe.oauth.CallType;
import org.scribe.oauth.OAuthSigner;
import org.scribe.oauth.Token;

public class RequestInspector {
    public static String getJsonInfo(OAuthSigner signer, Request request, Token accessToken) {
        StringBuilder info = new StringBuilder();
        info.append("{");
        String toSign = signer.getStringToSign(request, CallType.RESOURCE);
        RequestInspector.addField("stringToSign", toSign, info);
        RequestInspector.addField("signature", signer.getSignature(toSign, accessToken.getSecret()), info);
        info.append("\"httpRequest\":{");
        RequestInspector.addField("verb", request.getVerb().name(), info);
        RequestInspector.addField("url", request.getUrl(), info);
        RequestInspector.addField("body", request.getBodyContents(), info);
        info.append("\"headers\":[");
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            RequestInspector.addObject(entry.getKey(), entry.getValue().replace("\"", "'"), info);
        }
        info.deleteCharAt(info.length() - 2);
        info.append("]");
        info.append("}");
        info.append("}");
        return info.toString();
    }

    private static final void addField(String key, String val, StringBuilder info) {
        info.append("\"" + key + "\":\"" + val + "\"");
        info.append(",");
    }

    private static final void addObject(String key, String val, StringBuilder info) {
        info.append("{");
        RequestInspector.addField(key, val, info);
        info.append("}");
    }
}

