/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import org.scribe.eq.DefaultEqualizer;
import org.scribe.http.Request;
import org.scribe.http.Response;
import org.scribe.oauth.CallType;
import org.scribe.oauth.OAuthSigner;
import org.scribe.oauth.RequestInspector;
import org.scribe.oauth.Token;

public class Scribe {
    private static Scribe instance;
    private final java.util.Properties config;
    private DefaultEqualizer eq;

    @Deprecated
    public static synchronized Scribe getInstance(java.util.Properties props) {
        if (instance == null) {
            instance = new Scribe(props);
        }
        return instance;
    }

    public Scribe(java.util.Properties props) {
        this.config = props;
        this.initEqualizer();
    }

    private void initEqualizer() {
        String eqName = this.config.getProperty("scribe.equalizer");
        if (this.isEmpty(eqName)) {
            this.eq = new DefaultEqualizer();
        } else {
            try {
                this.eq = (DefaultEqualizer)Class.forName(eqName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initalize Scribe equalizer", e);
            }
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() <= 0;
    }

    public Token getRequestToken() {
        Request request = this.getRTRequest();
        OAuthSigner signer = this.getOAuthSigner();
        signer.signForRequestToken(request, this.config.getProperty("callback.url"));
        this.eq.tuneRequest(request, CallType.REQUEST_TOKEN);
        Response response = request.send();
        return this.eq.parseRequestTokens(response.getBody());
    }

    private Request getRTRequest() {
        return new Request(Request.Verb.valueOf(this.config.getProperty("request.token.verb")), this.config.getProperty("request.token.url"));
    }

    private OAuthSigner getOAuthSigner() {
        return new OAuthSigner(this.config.getProperty("consumer.key"), this.config.getProperty("consumer.secret"), this.eq);
    }

    public Token getAccessToken(Token token, String verifier) {
        Request request = this.getATRequest();
        OAuthSigner signer = this.getOAuthSigner();
        signer.signForAccessToken(request, token, verifier);
        this.eq.tuneRequest(request, CallType.ACCESS_TOKEN);
        Response response = request.send();
        return this.eq.parseAccessTokens(response.getBody());
    }

    private Request getATRequest() {
        return new Request(Request.Verb.valueOf(this.config.getProperty("access.token.verb")), this.config.getProperty("access.token.url"));
    }

    public void signRequest(Request request, Token token) {
        OAuthSigner signer = this.getOAuthSigner();
        signer.sign(request, token);
        this.eq.tuneRequest(request, CallType.RESOURCE);
    }

    public String getJsonInfo(Request request, Token token) {
        return RequestInspector.getJsonInfo(this.getOAuthSigner(), request, token);
    }

    public static class Properties {
        public static final String EQUALIZER = "scribe.equalizer";
        public static final String REQUEST_TOKEN_URL = "request.token.url";
        public static final String CALLBACK_URL = "callback.url";
        public static final String REQUEST_TOKEN_VERB = "request.token.verb";
        public static final String ACCESS_TOKEN_URL = "access.token.url";
        public static final String ACCESS_TOKEN_VERB = "access.token.verb";
        public static final String CONSUMER_SECRET = "consumer.secret";
        public static final String CONSUMER_KEY = "consumer.key";
    }
}

