/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ListenerSubscriptionPair;
import org.mule.context.notification.ServerNotificationManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNotificationManagerConfigurator
implements MuleContextAware,
SmartFactoryBean,
ApplicationContextAware {
    private MuleContext muleContext;
    private ApplicationContext applicationContext;
    private Boolean dynamic;
    private Map interfaceToEvents;
    private Collection interfaces;
    private Collection<ListenerSubscriptionPair> pairs;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object getObject() throws Exception {
        ServerNotificationManager notificationManager = this.muleContext.getNotificationManager();
        if (this.dynamic != null) {
            notificationManager.setNotificationDynamic(this.dynamic);
        }
        if (this.interfaceToEvents != null) {
            notificationManager.setInterfaceToTypes(this.interfaceToEvents);
        }
        if (this.interfaces != null) {
            notificationManager.setDisabledInterfaces(this.interfaces);
        }
        Set<ListenerSubscriptionPair> subs = this.getMergedListeners(notificationManager);
        for (ListenerSubscriptionPair sub : subs) {
            if (notificationManager.isListenerRegistered(sub.getListener())) continue;
            notificationManager.addListenerSubscriptionPair(sub);
        }
        return notificationManager;
    }

    protected Set<ListenerSubscriptionPair> getMergedListeners(ServerNotificationManager notificationManager) {
        HashSet<ListenerSubscriptionPair> mergedListeners = new HashSet<ListenerSubscriptionPair>();
        String[] listenerBeans = this.applicationContext.getBeanNamesForType(ServerNotificationListener.class, false, true);
        HashSet<ListenerSubscriptionPair> adhocListeners = new HashSet<ListenerSubscriptionPair>();
        for (String name : listenerBeans) {
            adhocListeners.add(new ListenerSubscriptionPair((ServerNotificationListener)this.applicationContext.getBean(name), null));
        }
        if (this.pairs != null) {
            mergedListeners.addAll(this.pairs);
            for (ListenerSubscriptionPair candidate : adhocListeners) {
                boolean explicityDefined = false;
                for (ListenerSubscriptionPair explicitListener : this.pairs) {
                    if (!candidate.getListener().equals(explicitListener.getListener())) continue;
                    explicityDefined = true;
                    break;
                }
                if (explicityDefined) continue;
                mergedListeners.add(candidate);
            }
        } else {
            mergedListeners.addAll(adhocListeners);
        }
        return mergedListeners;
    }

    public Class getObjectType() {
        return ServerNotificationManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = new Boolean(dynamic);
    }

    public void setInterfaceToTypes(Map interfaceToEvents) throws ClassNotFoundException {
        this.interfaceToEvents = interfaceToEvents;
    }

    public void setAllListenerSubscriptionPairs(Collection pairs) {
        this.pairs = pairs;
    }

    public void setDisabledInterfaces(Collection interfaces) throws ClassNotFoundException {
        this.interfaces = interfaces;
    }

    public boolean isEagerInit() {
        return true;
    }

    public boolean isPrototype() {
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

