/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history;

import java.io.Serializable;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistorySession;
import org.jbpm.pvm.internal.model.ExecutionImpl;

public abstract class HistoryEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecutionImpl execution;

    public void setExecution(ExecutionImpl execution) {
        this.execution = execution;
    }

    public abstract void process();

    public static void fire(HistoryEvent historyEvent) {
        HistoryEvent.fire(historyEvent, null);
    }

    public static void fire(HistoryEvent historyEvent, ExecutionImpl execution) {
        HistorySession historySession;
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment != null && (historySession = environment.get(HistorySession.class)) != null) {
            historyEvent.setExecution(execution);
            historySession.process(historyEvent);
        }
    }
}

