/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.events;

import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.events.ActivityEnd;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskInstanceImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDelete
extends ActivityEnd {
    private static final long serialVersionUID = 1L;
    protected TaskImpl task;
    protected String reason;

    public TaskDelete(TaskImpl task, String reason) {
        if (task.getExecution() != null) {
            throw new JbpmException("tasks related to an execution must be completed. they cannot just be deleted");
        }
        this.task = task;
        this.reason = reason;
    }

    @Override
    protected void updateHistoryActivityInstance(HistoryActivityInstanceImpl historyActivityInstance) {
        super.updateHistoryActivityInstance(historyActivityInstance);
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        HistoryTaskImpl historyTask = dbSession.get(HistoryTaskImpl.class, this.task.getDbid());
        historyTask.setState(this.reason);
        historyTask.setEndTime(Clock.getCurrentTime());
    }

    @Override
    protected Class<? extends HistoryActivityInstanceImpl> getHistoryActivityInstanceClass() {
        return HistoryTaskInstanceImpl.class;
    }
}

