/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireJobsCmd
implements Command<Collection<Long>> {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)AcquireJobsCmd.class.getName());
    private static final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    JobExecutor jobExecutor;

    public AcquireJobsCmd(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public Collection<Long> execute(Environment environment) throws Exception {
        ArrayList<Long> acquiredJobDbids;
        block12: {
            acquiredJobDbids = new ArrayList<Long>();
            try {
                JobImpl<?> job;
                ArrayList acquiredJobs = new ArrayList();
                DbSession dbSession = (DbSession)environment.get(DbSession.class);
                if (log.isTraceEnabled()) {
                    log.trace("start querying first acquirable job...");
                }
                if ((job = dbSession.findFirstAcquirableJob()) != null) {
                    if (job.isExclusive()) {
                        if (log.isTraceEnabled()) {
                            log.trace("exclusive acquirable job found (" + job + "). querying for other exclusive jobs to lock them all in one tx...");
                        }
                        List<JobImpl<?>> otherExclusiveJobs = dbSession.findExclusiveJobs((Execution)job.getProcessInstance());
                        acquiredJobs.addAll(otherExclusiveJobs);
                    } else {
                        acquiredJobs.add(job);
                    }
                    for (JobImpl jobImpl : acquiredJobs) {
                        long lockExpirationTime = System.currentTimeMillis() + (long)this.jobExecutor.getLockMillis();
                        if (log.isTraceEnabled()) {
                            log.trace("trying to obtain a lock for '" + jobImpl + "' with exp " + timeFormat.format(new Date(lockExpirationTime)));
                        }
                        jobImpl.acquire(this.jobExecutor.getName(), new Date(lockExpirationTime));
                        acquiredJobDbids.add(jobImpl.getDbid());
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace("no acquirable jobs in job table");
                }
                if (log.isTraceEnabled()) {
                    log.trace("locking jobs " + acquiredJobDbids);
                }
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("JbpmDS not bound") != -1) break block12;
                throw e;
            }
        }
        return acquiredJobDbids;
    }
}

