/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.pvm.internal.cmd.CreateProcessInstanceQueryCmd;
import org.jbpm.pvm.internal.cmd.DeleteProcessInstance;
import org.jbpm.pvm.internal.cmd.EndProcessInstance;
import org.jbpm.pvm.internal.cmd.FindExecutionCmd;
import org.jbpm.pvm.internal.cmd.GetExecutionVariableNamesCmd;
import org.jbpm.pvm.internal.cmd.GetExecutionVariablesCmd;
import org.jbpm.pvm.internal.cmd.SetExecutionVariablesCmd;
import org.jbpm.pvm.internal.cmd.SignalCmd;
import org.jbpm.pvm.internal.cmd.StartProcessInstanceCmd;
import org.jbpm.pvm.internal.cmd.StartProcessInstanceInLatestCmd;
import org.jbpm.pvm.internal.query.ProcessInstanceQueryImpl;
import org.jbpm.pvm.internal.svc.AbstractServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionServiceImpl
extends AbstractServiceImpl
implements ExecutionService {
    public ProcessInstance startProcessInstanceById(String processDefinitionId) {
        return this.commandService.execute(new StartProcessInstanceCmd(processDefinitionId, null, null));
    }

    public ProcessInstance startProcessInstanceById(String processDefinitionId, String executionKey) {
        return this.commandService.execute(new StartProcessInstanceCmd(processDefinitionId, null, executionKey));
    }

    public ProcessInstance startProcessInstanceById(String processDefinitionId, Map<String, Object> variables) {
        return this.commandService.execute(new StartProcessInstanceCmd(processDefinitionId, variables, null));
    }

    public ProcessInstance startProcessInstanceById(String processDefinitionId, Map<String, Object> variables, String executionKey) {
        return this.commandService.execute(new StartProcessInstanceCmd(processDefinitionId, variables, executionKey));
    }

    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey) {
        return this.commandService.execute(new StartProcessInstanceInLatestCmd(processDefinitionKey, null, null));
    }

    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, ?> variables) {
        return this.commandService.execute(new StartProcessInstanceInLatestCmd(processDefinitionKey, variables, null));
    }

    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, String executionKey) {
        return this.commandService.execute(new StartProcessInstanceInLatestCmd(processDefinitionKey, null, executionKey));
    }

    public ProcessInstance startProcessInstanceByKey(String processDefinitionKey, Map<String, ?> variables, String executionKey) {
        return this.commandService.execute(new StartProcessInstanceInLatestCmd(processDefinitionKey, variables, executionKey));
    }

    public ProcessInstance signalExecutionById(String executionId) {
        return this.commandService.execute(new SignalCmd(executionId, null, null));
    }

    public ProcessInstance signalExecutionById(String executionId, String signalName) {
        return this.commandService.execute(new SignalCmd(executionId, signalName, null));
    }

    public ProcessInstance signalExecutionById(String executionId, String signalName, Map<String, ?> parameters) {
        return this.commandService.execute(new SignalCmd(executionId, signalName, parameters));
    }

    public ProcessInstance signalExecutionById(String executionId, Map<String, ?> parameters) {
        return this.commandService.execute(new SignalCmd(executionId, null, parameters));
    }

    public Execution findExecutionById(String executionId) {
        return this.commandService.execute(new FindExecutionCmd(executionId));
    }

    public ProcessInstance findProcessInstanceById(String executionId) {
        return (ProcessInstance)this.commandService.execute(new FindExecutionCmd(executionId));
    }

    public ProcessInstanceQuery createProcessInstanceQuery() {
        ProcessInstanceQueryImpl query = this.commandService.execute(new CreateProcessInstanceQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    public void endProcessInstance(String processInstanceId, String state) {
        this.commandService.execute(new EndProcessInstance(processInstanceId, state));
    }

    public void deleteProcessInstance(String processInstanceId) {
        this.commandService.execute(new DeleteProcessInstance(processInstanceId));
    }

    public void deleteProcessInstanceCascade(String processInstanceId) {
        this.commandService.execute(new DeleteProcessInstance(processInstanceId, true));
    }

    public Object getVariable(String executionId, String variableName) {
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add(variableName);
        Map<String, Object> variables = this.commandService.execute(new GetExecutionVariablesCmd(executionId, variableNames));
        return variables.get(variableName);
    }

    public Set<String> getVariableNames(String executionId) {
        return this.commandService.execute(new GetExecutionVariableNamesCmd(executionId));
    }

    public Map<String, Object> getVariables(String executionId, Set<String> variableNames) {
        return this.commandService.execute(new GetExecutionVariablesCmd(executionId, variableNames));
    }

    public void setVariable(String executionId, String name, Object value) {
        SetExecutionVariablesCmd cmd = new SetExecutionVariablesCmd(executionId);
        cmd.addVariable(name, value);
        this.commandService.execute(cmd);
    }

    public void setVariables(String executionId, Map<String, ?> variables) {
        SetExecutionVariablesCmd cmd = new SetExecutionVariablesCmd(executionId);
        cmd.setVariables(variables);
        this.commandService.execute(cmd);
    }
}

