/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class DistinctValues
extends CollatingFunction {
    private transient AtomicComparer atomicComparer;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (this.stringCollator != null) {
            int n = this.argument[0].getItemType(staticContext.getConfiguration().getTypeHierarchy()).getPrimitiveType();
            this.atomicComparer = AtomicSortComparer.makeSortComparer(this.stringCollator, n, staticContext.makeEarlyEvaluationContext());
        }
    }

    public AtomicComparer getAtomicComparer() {
        return this.atomicComparer;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicComparer atomicComparer = this.atomicComparer;
        if (atomicComparer == null) {
            int n = this.argument[0].getItemType(xPathContext.getConfiguration().getTypeHierarchy()).getPrimitiveType();
            atomicComparer = this.makeAtomicSortComparer(n, xPathContext);
        }
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        return new DistinctIterator(sequenceIterator, atomicComparer);
    }

    private AtomicComparer makeAtomicSortComparer(int n, XPathContext xPathContext) throws XPathException {
        StringCollator stringCollator = this.getCollator(1, xPathContext);
        AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, n, xPathContext);
        return atomicComparer;
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private AtomicComparer comparer;
        private int position;
        private AtomicValue current;
        private HashSet lookup = new HashSet(40);

        public DistinctIterator(SequenceIterator sequenceIterator, AtomicComparer atomicComparer) {
            this.base = sequenceIterator;
            this.comparer = atomicComparer;
            this.position = 0;
        }

        public Item next() throws XPathException {
            AtomicValue atomicValue;
            ComparisonKey comparisonKey;
            do {
                if ((atomicValue = (AtomicValue)this.base.next()) != null) continue;
                this.current = null;
                this.position = -1;
                return null;
            } while (this.lookup.contains(comparisonKey = this.comparer.getComparisonKey(atomicValue)));
            this.lookup.add(comparisonKey);
            this.current = atomicValue;
            ++this.position;
            return atomicValue;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new DistinctIterator(this.base.getAnother(), this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

