/*
 * $Id: ChunkingTestCase.java 19191 2010-08-25 21:05:23Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.http.functional;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.http.HttpConnector;

public class ChunkingTestCase extends FunctionalTestCase
{

    protected String getConfigResources()
    {
        return "chunking-test.xml";
    }

    public void testPartiallyReadRequest() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        
        byte[] msg = new byte[100*1024];
        
        MuleMessage result = client.send("http://localhost:60200/foo", msg, null);
        assertEquals("Hello", result.getPayloadAsString());
        int status = result.getInboundProperty(HttpConnector.HTTP_STATUS_PROPERTY, 0);
        assertEquals(200, status);
        
        result = client.send("http://localhost:60200/foo", msg, null);
        assertEquals("Hello", result.getPayloadAsString());
        status = result.getInboundProperty(HttpConnector.HTTP_STATUS_PROPERTY, 0);
        assertEquals(200, status);
    }

}


