/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.expression;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.DefaultMuleException;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.logic.OrFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFilterParser {
    public Filter parseFilterString(String filterString) throws DefaultMuleException {
        List<String> strings = this.split(filterString);
        Filter filter = null;
        for (String s : strings) {
            if ((s = s.trim()).equals("AND")) {
                filter = new AndFilter(filter);
                continue;
            }
            if (s.equals("OR")) {
                filter = new OrFilter(filter);
                continue;
            }
            if (filter instanceof AndFilter) {
                ((AndFilter)filter).getFilters().add(new ExpressionFilter(s));
                continue;
            }
            if (filter instanceof OrFilter) {
                ((OrFilter)filter).getFilters().add(new ExpressionFilter(s));
                continue;
            }
            if (filter == null) {
                filter = new ExpressionFilter(s);
                continue;
            }
            throw new DefaultMuleException("Expression Filter is malformed. IF this is a nested filter make sure each expression is separated by either 'AND' or 'OR'");
        }
        return filter;
    }

    protected List<String> split(String string) {
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i > -1) {
            int a = string.indexOf("AND", i);
            int o = string.indexOf("OR", i);
            if (a > 1) {
                strings.add(string.substring(0, a));
                strings.add("AND");
                string = string.substring(a + 4).trim();
                continue;
            }
            if (o > 1) {
                strings.add(string.substring(0, o));
                strings.add("OR");
                string = string.substring(o + 3).trim();
                continue;
            }
            strings.add(string);
            i = -1;
        }
        return strings;
    }
}

