/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import java.util.Map;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.util.XMLUtils;
import org.w3c.dom.Document;

public class JXPathExpressionEvaluator
implements ExpressionEvaluator,
MuleContextAware {
    public static final String NAME = "jxpath";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected transient MuleContext muleContext;
    private NamespaceManager namespaceManager;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object evaluate(String expression, MuleMessage message) {
        Document document;
        try {
            document = XMLUtils.toW3cDocument(message.getPayload());
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return null;
        }
        JXPathContext context = document != null ? this.createContextForXml(document) : this.createContextForBean(message.getPayload());
        return this.getExpressionValue(context, expression);
    }

    private JXPathContext createContextForXml(final Document document) {
        Container container = new Container(){

            public Object getValue() {
                return document;
            }

            public void setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        };
        return JXPathContext.newContext((Object)container);
    }

    private JXPathContext createContextForBean(Object payload) {
        return JXPathContext.newContext((Object)payload);
    }

    private Object getExpressionValue(JXPathContext context, String expression) {
        Object result;
        block3: {
            NamespaceManager theNamespaceManager = this.getNamespaceManager();
            if (theNamespaceManager != null) {
                this.addNamespacesToContext(theNamespaceManager, context);
            }
            result = null;
            try {
                result = context.getValue(expression);
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("failed to process JXPath expression: " + expression), (Throwable)e);
            }
        }
        return result;
    }

    protected void addNamespacesToContext(NamespaceManager manager, JXPathContext context) {
        for (Map.Entry entry : manager.getNamespaces().entrySet()) {
            try {
                context.registerNamespace(entry.getKey().toString(), entry.getValue().toString());
            }
            catch (Exception e) {
                throw new ExpressionRuntimeException(XmlMessages.failedToRegisterNamespace(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    protected synchronized NamespaceManager getNamespaceManager() {
        if (this.namespaceManager == null) {
            try {
                if (this.muleContext != null) {
                    this.namespaceManager = this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
                }
            }
            catch (RegistrationException e) {
                throw new ExpressionRuntimeException(CoreMessages.failedToLoad("NamespaceManager"), (Throwable)e);
            }
        }
        return this.namespaceManager;
    }
}

