/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.module.xml.util.XMLUtils;
import org.w3c.dom.Document;

public class XmlToDomDocument
extends AbstractXmlTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public Object transformMessage(MuleMessage message, String encoding) throws TransformerException {
        Object src = message.getPayload();
        try {
            Source sourceDoc = XMLUtils.toXmlSource(this.getXMLInputFactory(), this.isUseStaxSource(), src);
            if (sourceDoc == null) {
                return null;
            }
            if (XMLStreamReader.class.equals((Object)this.returnType)) {
                return this.getXMLInputFactory().createXMLStreamReader(sourceDoc);
            }
            if (this.returnType.getType().isAssignableFrom(sourceDoc.getClass())) {
                return sourceDoc;
            }
            AbstractXmlTransformer.ResultHolder holder = XmlToDomDocument.getResultHolder(this.returnType.getType());
            if (holder == null) {
                holder = XmlToDomDocument.getResultHolder(Document.class);
            }
            Transformer idTransformer = XMLUtils.getTransformer();
            idTransformer.setOutputProperty("encoding", encoding);
            idTransformer.transform(sourceDoc, holder.getResult());
            return holder.getResultObject();
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

