/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.tsmx;

import com.arjuna.ats.tsmx.agent.AgentInterface;
import com.arjuna.ats.tsmx.agent.exceptions.AgentNotFoundException;
import com.arjuna.ats.tsmx.common.Configuration;
import com.arjuna.ats.tsmx.logging.tsmxLogger;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TransactionServiceMX {
    public static final String AGENT_IMPLEMENTATION_PROPERTY = "com.arjuna.ats.tsmx.agentimpl";
    private static final String DEFAULT_AGENT_IMPLEMENTATION = "com.arjuna.ats.internal.tsmx.agent.implementations.ri.RefAgentImpl";
    private static final String MBEAN_PROPERTY_PREFIX = "com.arjuna.ats.tsmx.mbean.";
    private static final String MBEAN_CLASSNAME_SUFFIX = ".classname";
    private static final String MBEAN_OBJECTNAME_SUFFIX = ".objectname";
    private static TransactionServiceMX _tsmx = null;
    private MBeanServer _mbeanServer = null;
    private ArrayList _beans = null;
    private AgentInterface _agent = null;
    private Properties _tsmxProps = null;

    public static final TransactionServiceMX getTransactionServiceMX() {
        if (_tsmx == null) {
            _tsmx = new TransactionServiceMX();
        }
        return _tsmx;
    }

    protected TransactionServiceMX() {
        if (tsmxLogger.logger.debugAllowed()) {
            tsmxLogger.logger.debug(2L, 4L, 1L, "TransactionService Management Extentions initialising");
        }
        try {
            this.loadProperties();
        }
        catch (Exception e) {
            throw new Error("An error occurred while trying to load the tsmx properties: " + e);
        }
        try {
            this._mbeanServer = this._agent.getAgent();
        }
        catch (AgentNotFoundException e) {
            throw new Error("Failed to find agent: " + e);
        }
        this._beans = new ArrayList();
        this.registerMBeans();
    }

    protected void loadProperties() throws Exception {
        if (this._agent == null) {
            this._tsmxProps = System.getProperties();
            InputStream inStr = Thread.currentThread().getContextClassLoader().getResourceAsStream(Configuration.propertiesFile());
            if (inStr != null) {
                this._tsmxProps.load(inStr);
            }
            String agentImpl = this._tsmxProps.getProperty(AGENT_IMPLEMENTATION_PROPERTY, DEFAULT_AGENT_IMPLEMENTATION);
            if (tsmxLogger.logger.isInfoEnabled()) {
                tsmxLogger.logger.info("Initialising JMX agent " + agentImpl);
            }
            this._agent = (AgentInterface)Thread.currentThread().getContextClassLoader().loadClass(agentImpl).newInstance();
        }
    }

    private final String stripNameFromProperty(String propertyName) {
        String name = null;
        if (propertyName.startsWith(MBEAN_PROPERTY_PREFIX)) {
            if (propertyName.endsWith(MBEAN_CLASSNAME_SUFFIX)) {
                name = propertyName.substring(MBEAN_PROPERTY_PREFIX.length());
                name = name.substring(0, name.indexOf(MBEAN_CLASSNAME_SUFFIX));
            } else if (propertyName.endsWith(MBEAN_OBJECTNAME_SUFFIX)) {
                name = propertyName.substring(MBEAN_PROPERTY_PREFIX.length());
                name = name.substring(0, name.indexOf(MBEAN_OBJECTNAME_SUFFIX));
            }
        }
        return name;
    }

    private static final String getClassPropertyName(String mbeanName) {
        return MBEAN_PROPERTY_PREFIX + mbeanName + MBEAN_CLASSNAME_SUFFIX;
    }

    private static final String getObjectPropertyName(String mbeanName) {
        return MBEAN_PROPERTY_PREFIX + mbeanName + MBEAN_OBJECTNAME_SUFFIX;
    }

    public final String getObjectName(String mbeanName) {
        return this._tsmxProps.getProperty(TransactionServiceMX.getObjectPropertyName(mbeanName));
    }

    public final Properties getProperties() {
        return this._tsmxProps;
    }

    public final AgentInterface getAgentInterface() {
        return this._agent;
    }

    private boolean registerMBeans() {
        boolean success = true;
        Properties props = this.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        HashSet<String> foundProperties = new HashSet<String>();
        if (tsmxLogger.logger.debugAllowed()) {
            tsmxLogger.logger.debug(2L, 4L, 1L, "Registering transaction service mbeans");
        }
        while (propNames.hasMoreElements()) {
            String mbeanName;
            String propertyName = (String)propNames.nextElement();
            if (!propertyName.startsWith(MBEAN_PROPERTY_PREFIX) || foundProperties.contains(mbeanName = this.stripNameFromProperty(propertyName))) continue;
            String mbeanClassname = props.getProperty(TransactionServiceMX.getClassPropertyName(mbeanName));
            String mbeanObjectName = props.getProperty(TransactionServiceMX.getObjectPropertyName(mbeanName));
            try {
                if (tsmxLogger.logger.debugAllowed()) {
                    tsmxLogger.logger.debug(2L, 4L, 1L, "Registering mbean '" + mbeanClassname + "' against '" + mbeanObjectName + "'");
                }
                this._mbeanServer.createMBean(mbeanClassname, new ObjectName(mbeanObjectName));
                this._beans.add(mbeanObjectName);
                foundProperties.add(mbeanName);
            }
            catch (InstanceAlreadyExistsException e) {
                if (!tsmxLogger.logger.isWarnEnabled()) continue;
                tsmxLogger.loggerI18N.warn("com.arjuna.ats.tsmx.TransactionServiceMX.mbeanalreadyregistered", new Object[]{mbeanObjectName});
            }
            catch (MBeanException e) {
                if (tsmxLogger.logger.isErrorEnabled()) {
                    tsmxLogger.loggerI18N.error("com.arjuna.ats.tsmx.TransactionServiceMX.failedtoregistermbean", new Object[]{mbeanObjectName, e.getTargetException().toString()});
                }
                success = false;
            }
            catch (Exception e) {
                if (tsmxLogger.logger.isErrorEnabled()) {
                    tsmxLogger.loggerI18N.error("com.arjuna.ats.tsmx.TransactionServiceMX.failedtoregistermbean", new Object[]{mbeanObjectName, e.toString()});
                }
                success = false;
            }
        }
        return success;
    }

    public boolean unregisterMBeans() {
        boolean success = true;
        for (int count = 0; count < this._beans.size(); ++count) {
            String name = (String)this._beans.get(count);
            try {
                this._mbeanServer.unregisterMBean(new ObjectName(name));
                this._beans.remove(count);
                continue;
            }
            catch (Exception e) {
                if (tsmxLogger.logger.isErrorEnabled()) {
                    tsmxLogger.loggerI18N.error("com.arjuna.ats.tsmx.TransactionServiceMX.failedtounregistermbean", new Object[]{name, e.toString()});
                }
                success = false;
            }
        }
        return success;
    }
}

