/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.SpringRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringConfigurationBuilder
extends AbstractConfigurationBuilder {
    private ApplicationContext appContext;
    private ApplicationContext parentContext;

    public SpringConfigurationBuilder(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public SpringConfigurationBuilder(ConfigurableApplicationContext appContext, ApplicationContext parentContext) {
        this.appContext = appContext;
        this.parentContext = parentContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doConfigure(MuleContext muleContext) throws Exception {
        SpringRegistry registry;
        if (this.parentContext != null) {
            if (!(this.appContext instanceof ConfigurableApplicationContext)) throw new ConfigurationException(MessageFactory.createStaticMessage("Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
            registry = new SpringRegistry((ConfigurableApplicationContext)this.appContext, this.parentContext, muleContext);
        } else {
            registry = new SpringRegistry(this.appContext, muleContext);
        }
        muleContext.addRegistry(registry);
        registry.initialise();
    }
}

