/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.ftp.FtpConnector;
import org.mule.transport.ftp.FtpMuleMessageFactory;

public class FtpMessageRequester
extends AbstractMessageRequester {
    protected final FtpConnector connector;

    public FtpMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (FtpConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        try {
            EndpointURI uri = this.endpoint.getEndpointURI();
            FTPClient client = this.connector.getFtp(uri);
            this.connector.destroyFtp(uri, client);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MuleMessage doRequest(long timeout) throws Exception {
        FTPClient client = null;
        try {
            client = this.connector.createFtpClient(this.endpoint);
            FTPFile fileToProcess = this.findFileToProcess(client);
            if (fileToProcess == null) {
                MuleMessage muleMessage = null;
                return muleMessage;
            }
            fileToProcess = this.prepareFile(client, fileToProcess);
            FtpMuleMessageFactory messageFactory = this.createMuleMessageFactory(client);
            MuleMessage muleMessage = messageFactory.create(fileToProcess, this.endpoint.getEncoding());
            return muleMessage;
        }
        finally {
            this.connector.releaseFtp(this.endpoint.getEndpointURI(), client);
        }
    }

    protected void initializeMessageFactory() throws InitialisationException {
    }

    protected FtpMuleMessageFactory createMuleMessageFactory(FTPClient client) throws CreateException {
        FtpMuleMessageFactory factory = (FtpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setStreaming(false);
        factory.setFtpClient(client);
        return factory;
    }

    protected FTPFile prepareFile(FTPClient client, FTPFile file) throws IOException {
        return file;
    }

    protected FTPFile findFileToProcess(FTPClient client) throws Exception {
        FTPFile[] files = this.listFiles(client);
        if (files != null) {
            FilenameFilter filenameFilter = this.getFilenameFilter();
            for (int i = 0; i < files.length; ++i) {
                FTPFile file = files[i];
                if (!file.isFile() || !filenameFilter.accept(null, file.getName()) || !this.connector.validateFile(file)) continue;
                return file;
            }
        }
        return null;
    }

    protected FTPFile[] listFiles(FTPClient client) throws IOException {
        FTPFile[] files = client.listFiles();
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new IOException("Ftp error: " + client.getReplyCode());
        }
        if (files == null || files.length == 0) {
            return null;
        }
        return files;
    }

    protected FilenameFilter getFilenameFilter() {
        if (this.endpoint.getFilter() instanceof FilenameFilter) {
            return (FilenameFilter)this.endpoint.getFilter();
        }
        return new AcceptAllFilenameFilter();
    }

    private static class AcceptAllFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

