/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.transport.AbstractMuleMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpMuleMessageFactory
extends AbstractMuleMessageFactory {
    private FTPClient ftpClient;
    private boolean streaming;

    public FtpMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        FTPFile file = (FTPFile)transportMessage;
        if (this.streaming) {
            InputStream stream = this.ftpClient.retrieveFileStream(file.getName());
            if (stream == null) {
                throw new IOException(MessageFormat.format("Failed to retrieve file {0}. Ftp error: {1}", file.getName(), this.ftpClient.getReplyCode()));
            }
            return stream;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.ftpClient.retrieveFile(file.getName(), (OutputStream)baos)) {
            throw new IOException(MessageFormat.format("Failed to retrieve file {0}. Ftp error: {1}", file.getName(), this.ftpClient.getReplyCode()));
        }
        byte[] bytes = baos.toByteArray();
        if (bytes.length > 0) {
            return bytes;
        }
        throw new IOException("File " + file.getName() + " is empty (zero bytes)");
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{FTPFile.class};
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        FTPFile file = (FTPFile)transportMessage;
        message.setOutboundProperty("originalFilename", (Object)file.getName());
        message.setOutboundProperty("fileSize", (Object)file.getSize());
        message.setOutboundProperty("timestamp", (Object)file.getTimestamp());
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }
}

