/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.auth;

import java.net.URISyntaxException;
import java.util.Properties;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.ParamFactory;
import org.scribe.http.Request;
import org.scribe.oauth.Scribe;
import org.scribe.oauth.Token;

public class OAuthAuthorizationHeaderParamFactory
implements ParamFactory {
    public String create(String paramName, boolean optional, InvocationContext invocationContext) throws URISyntaxException {
        Properties p = new Properties();
        p.putAll(invocationContext.getIBeanConfig().getPropertyParams());
        Scribe scribe = new Scribe(p);
        String requestUrl = invocationContext.getParsedCallUri();
        String tokenString = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.access.token");
        if (tokenString == null) {
            throw new RuntimeException("No access token found for key: ");
        }
        String secretString = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.secret.key");
        if (secretString == null) {
            throw new RuntimeException("No secret key found for key: oauth.secret.key");
        }
        Token accessToken = new Token(tokenString, secretString);
        String httpMethod = (String)invocationContext.getIBeanConfig().getPropertyParams().get("http.method");
        if (httpMethod == null) {
            httpMethod = "GET";
        }
        Request.Verb verb = Request.Verb.valueOf((String)httpMethod.toUpperCase());
        Request request = new Request(verb, requestUrl);
        scribe.signRequest(request, accessToken);
        String authHeader = (String)request.getHeaders().get(paramName);
        return authHeader;
    }
}

