/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.jpdl.internal.activity.JpdlActivity;
import org.jbpm.pvm.internal.model.Activity;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.Transition;

public class ForkActivity
extends JpdlActivity {
    private static final long serialVersionUID = 1L;

    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        ArrayList<Transition> forkingTransitions = new ArrayList<Transition>();
        List outgoingTransitions = activity.getOutgoingTransitions();
        for (Transition transition : outgoingTransitions) {
            Condition condition = transition.getCondition();
            if (condition != null && !condition.evaluate((OpenExecution)execution)) continue;
            forkingTransitions.add(transition);
        }
        if (forkingTransitions.size() == 0) {
            execution.end();
        } else if (forkingTransitions.size() == 1) {
            execution.take((Transition)forkingTransitions.get(0));
        } else {
            ExecutionImpl concurrentRoot = null;
            if ("active-root".equals(execution.getState())) {
                concurrentRoot = execution;
                execution.setState("inactive-concurrent-root");
                execution.setActivity(null);
            } else if ("active-concurrent".equals(execution.getState())) {
                concurrentRoot = execution.getParent();
            }
            for (Transition transition : forkingTransitions) {
                String childExecutionName = transition.getName();
                ExecutionImpl concurrentExecution = concurrentRoot.createExecution(childExecutionName);
                concurrentExecution.setActivity((Activity)activity);
                concurrentExecution.setState("active-concurrent");
                concurrentExecution.take(transition);
                if (!concurrentRoot.isEnded()) continue;
                break;
            }
        }
    }
}

