/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.jpdl.internal.xml.UnresolvedTransitions;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.util.TagBinding;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public abstract class JpdlBinding
extends TagBinding {
    public JpdlBinding(String tagName) {
        super(tagName, null, null);
    }

    public abstract Object parseJpdl(Element var1, Parse var2, JpdlParser var3);

    public final Object parse(Element element, Parse parse, Parser parser) {
        return this.parseJpdl(element, parse, (JpdlParser)parser);
    }

    public void parseName(Element element, ActivityImpl activity, Parse parse) {
        String name = XmlUtil.attribute((Element)element, (String)"name", (boolean)this.isNameRequired(), (Parse)parse);
        if (name != null) {
            if ("".equals(name)) {
                parse.addProblem(XmlUtil.errorMessageAttribute((Element)element, (String)"name", (String)name, (String)"is empty"), element);
            } else if (name.indexOf(47) != -1) {
                parse.addProblem(XmlUtil.errorMessageAttribute((Element)element, (String)"name", (String)name, (String)"contains slash (/)"), element);
            }
            activity.setName(name);
        }
    }

    public boolean isNameRequired() {
        return true;
    }

    public void parseTransitions(Element element, ActivityImpl activity, Parse parse, JpdlParser jpdlParser) {
        List transitionElements = XmlUtil.elements((Element)element, (String)"transition");
        UnresolvedTransitions unresolvedTransitions = (UnresolvedTransitions)parse.contextStackFind(UnresolvedTransitions.class);
        for (Element transitionElement : transitionElements) {
            String transitionName = XmlUtil.attribute((Element)transitionElement, (String)"name", (boolean)false, (Parse)parse);
            Element timerElement = XmlUtil.element((Element)transitionElement, (String)"timer");
            if (timerElement != null) {
                if (transitionName != null) {
                    TimerDefinitionImpl timerDefinitionImpl = jpdlParser.parseTimerDefinition(timerElement, parse, (ScopeElementImpl)activity);
                    timerDefinitionImpl.setSignalName(transitionName);
                } else {
                    parse.addProblem("a transition name is required when a timer is placed on a transition", element);
                }
            }
            TransitionImpl transition = activity.createOutgoingTransition();
            transition.setName(transitionName);
            unresolvedTransitions.add(transition, transitionElement);
            jpdlParser.parseOnEvent(transitionElement, parse, (ObservableElementImpl)transition, "take");
        }
    }
}

