/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.task.Assignable;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.activity.JpdlExternalActivity;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskActivityStart;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObservableElement;
import org.jbpm.pvm.internal.model.Transition;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.AssignableDefinitionImpl;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneDefinitionImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivity
extends JpdlExternalActivity {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)TaskActivity.class.getName());
    protected TaskDefinitionImpl taskDefinition;

    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        DbSession dbSession = (DbSession)EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = dbSession.createTask();
        task.setTaskDefinition(this.taskDefinition);
        task.setExecution(execution);
        task.setProcessInstance(execution.getProcessInstance());
        task.setSignalling(true);
        if (this.taskDefinition.getName() != null) {
            task.setName(this.taskDefinition.getName());
        } else {
            task.setName(execution.getActivityName());
        }
        task.setDescription(this.taskDefinition.getDescription());
        task.setPriority(this.taskDefinition.getPriority());
        task.setFormResourceName(this.taskDefinition.getFormResourceName());
        dbSession.save((Object)task);
        SwimlaneDefinitionImpl swimlaneDefinition = this.taskDefinition.getSwimlaneDefinition();
        if (swimlaneDefinition != null) {
            SwimlaneImpl swimlane = execution.getInitializedSwimlane(swimlaneDefinition);
            task.setSwimlane(swimlane);
            task.setAssignee(swimlane.getAssignee());
            for (ParticipationImpl participant : swimlane.getParticipations()) {
                task.addParticipation(participant.getUserId(), participant.getGroupId(), participant.getType());
            }
        }
        execution.initializeAssignments((AssignableDefinitionImpl)this.taskDefinition, (Assignable)task);
        HistoryEvent.fire((HistoryEvent)new TaskActivityStart(task), (ExecutionImpl)execution);
        execution.waitForSignal();
    }

    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        ActivityImpl activity = execution.getActivity();
        if (parameters != null) {
            execution.setVariables(parameters);
        }
        execution.fire(signalName, (ObservableElement)activity);
        DbSession taskDbSession = (DbSession)EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = taskDbSession.findTaskByExecution((Execution)execution);
        task.setSignalling(false);
        Transition transition = null;
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions != null && !outgoingTransitions.isEmpty()) {
            transition = activity.findOutgoingTransition(signalName);
            if (transition == null) {
                if ("completed".equals(signalName)) {
                    transition = outgoingTransitions.size() == 1 ? (Transition)outgoingTransitions.get(0) : activity.getDefaultOutgoingTransition();
                } else {
                    throw new JbpmException("No outcome named '" + signalName + "' was found.");
                }
            }
            if (transition != null) {
                execution.take(transition);
            }
        }
    }

    public TaskDefinitionImpl getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
    }
}

