/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.ProcessDeployer;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlDeployer
extends ProcessDeployer {
    private static Log log = Log.getLog((String)JpdlDeployer.class.getName());
    private static Parser parser = new Parser();
    static JpdlParser jpdlParser = new JpdlParser();
    static final String jpdlExtension = ".jpdl.xml";

    public JpdlDeployer() {
        super(jpdlExtension, (Parser)jpdlParser);
    }

    protected String getProcessLanguageId() {
        return "";
    }

    public void updateResource(DeploymentImpl deployment, String resourceName, byte[] bytes) {
        Document document;
        Element documentElement;
        String tagName;
        if (resourceName.endsWith(jpdlExtension) && "process-update".equals(tagName = XmlUtil.getTagLocalName((Element)(documentElement = (document = parser.createParse().setInputStream((InputStream)new ByteArrayInputStream(bytes)).execute().getDocument()).getDocumentElement())))) {
            this.updateJpdlProcessResource(deployment, resourceName, document);
            return;
        }
        super.updateResource(deployment, resourceName, bytes);
    }

    public void updateJpdlProcessResource(DeploymentImpl deployment, String resourceName, Document updateDocument) {
        byte[] processBytes = deployment.getBytes(resourceName);
        Document processDocument = parser.createParse().setInputStream((InputStream)new ByteArrayInputStream(processBytes)).execute().checkErrors("jPDL process update document").getDocument();
        Element processElement = processDocument.getDocumentElement();
        Element processUpdateElement = updateDocument.getDocumentElement();
        Element processUpdateDescriptionElement = XmlUtil.element((Element)processUpdateElement, (String)"description");
        if (processUpdateDescriptionElement != null) {
            Element processDescriptionElement = XmlUtil.element((Element)processElement, (String)"description");
            if (processDescriptionElement != null) {
                processElement.removeChild(processDescriptionElement);
            }
            Node clonedDescriptionElement = processUpdateDescriptionElement.cloneNode(true);
            processDocument.adoptNode(clonedDescriptionElement);
            processElement.appendChild(clonedDescriptionElement);
        }
        this.updateActivities(processDocument, processElement, processUpdateElement);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(processDocument);
            transformer.transform(source, result);
            String updatedProcessXml = result.getWriter().toString();
            log.debug("updated process xml: \n" + updatedProcessXml);
            byte[] bytes = updatedProcessXml.getBytes();
            deployment.addResourceFromInputStream(resourceName, (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            throw new JbpmException("couldn't serialize updated process dom model", (Throwable)e);
        }
    }

    private void updateActivities(Document processDocument, Element activityContainerElement, Element updateContainerElement) {
        Set<String> activityNames = jpdlParser.getActivityTagNames();
        Map<String, Element> processActivityMap = this.getActivityMap(activityContainerElement, activityNames);
        Map<String, Element> updateActivityMap = this.getActivityMap(updateContainerElement, activityNames);
        for (String activityName : updateActivityMap.keySet()) {
            Element updateActivity = updateActivityMap.get(activityName);
            Element processActivity = processActivityMap.get(activityName);
            if (processActivity == null) {
                throw new JbpmException("unmatching update activity " + activityName);
            }
            Node clonedUpdateActivity = updateActivity.cloneNode(true);
            processDocument.adoptNode(clonedUpdateActivity);
            activityContainerElement.insertBefore(clonedUpdateActivity, processActivity);
            activityContainerElement.removeChild(processActivity);
        }
    }

    protected Map<String, Element> getActivityMap(Element containerElement, Set<String> activityNames) {
        HashMap<String, Element> activityMap = new HashMap<String, Element>();
        for (Element element : XmlUtil.elements((Element)containerElement)) {
            String tagName = XmlUtil.getTagLocalName((Element)element);
            if (!activityNames.contains(tagName)) continue;
            String activityName = element.getAttribute("name");
            activityMap.put(activityName, element);
        }
        return activityMap;
    }
}

