/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Map;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.client.ClientProcessInstance;
import org.jbpm.pvm.internal.cmd.VariablesCmd;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.session.RepositorySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartProcessInstanceCmd
extends VariablesCmd<ProcessInstance> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String executionKey;

    public StartProcessInstanceCmd(String processDefinitionId, Map<String, Object> variables, String executionKey) {
        this.processDefinitionId = processDefinitionId;
        this.variables = variables;
        this.executionKey = executionKey;
    }

    public ProcessInstance execute(Environment environment) throws Exception {
        RepositorySession repositorySession = (RepositorySession)environment.get(RepositorySession.class);
        ProcessDefinitionImpl processDefinition = repositorySession.findProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new JbpmException("no process definition with id '" + this.processDefinitionId + "'");
        }
        ClientProcessInstance processInstance = processDefinition.createProcessInstance(this.executionKey);
        processInstance.setVariables(this.variables);
        processInstance.start();
        if (!processInstance.isEnded()) {
            Session session = (Session)environment.get(Session.class);
            session.save((Object)processInstance);
        }
        return processInstance;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionId = processDefinitionKey;
    }

    public String getExecutionKey() {
        return this.executionKey;
    }

    public void setExecutionKey(String executionKey) {
        this.executionKey = executionKey;
    }
}

