/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.hibernate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;
import org.hibernate.usertype.ParameterizedType;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.type.Converter;

public class ConverterType
extends ImmutableType
implements ParameterizedType {
    private static final long serialVersionUID = 1L;
    private static Map<Class<?>, String> converterNames = null;
    private static Map<String, Converter> converters = null;

    public Object fromStringValue(String arg0) throws HibernateException {
        return null;
    }

    public Object get(ResultSet resultSet, String name) throws HibernateException, SQLException {
        String converterName = resultSet.getString(name);
        return converters.get(converterName);
    }

    public void set(PreparedStatement stmt, Object value, int index) throws HibernateException, SQLException {
        String converterName = value != null ? converterNames.get(value.getClass()) : null;
        stmt.setString(index, converterName);
    }

    public int sqlType() {
        return 12;
    }

    public String toString(Object arg0) throws HibernateException {
        return null;
    }

    public String getName() {
        return "converter";
    }

    public Class getReturnedClass() {
        return Converter.class;
    }

    public void setParameterValues(Properties properties) {
        converterNames = new HashMap();
        converters = new HashMap<String, Converter>();
        for (Object key : properties.keySet()) {
            String converterClassName = (String)key;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> converterClass = null;
                try {
                    converterClass = Class.forName(converterClassName, true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    converterClass = Class.forName(converterClassName, true, classLoader);
                }
                String converterName = properties.getProperty(converterClassName);
                converterNames.put(converterClass, converterName);
                Converter converter = (Converter)converterClass.newInstance();
                converters.put(converterName, converter);
            }
            catch (Exception e) {
                throw new JbpmException("couldn't initialize converter type " + converterClassName, (Throwable)e);
            }
        }
    }
}

