/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.identity.impl;

import java.util.Arrays;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.identity.impl.GroupImpl;
import org.jbpm.pvm.internal.identity.impl.MembershipImpl;
import org.jbpm.pvm.internal.identity.impl.UserImpl;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySessionImpl
implements IdentitySession {
    protected Session session;

    @Override
    public String createUser(String userName, String givenName, String familyName, String businessEmail) {
        UserImpl user = new UserImpl(userName, givenName, familyName);
        user.setBusinessEmail(businessEmail);
        long dbid = EnvironmentImpl.getFromCurrent(DbidGenerator.class).getNextId();
        user.setDbid(dbid);
        this.session.save((Object)user);
        return user.getId();
    }

    @Override
    public User findUserById(String userId) {
        return (User)this.session.createCriteria(UserImpl.class).add((Criterion)Restrictions.eq((String)"id", (Object)userId)).uniqueResult();
    }

    @Override
    public List<User> findUsersById(String ... userIds) {
        List users = this.session.createCriteria(UserImpl.class).add(Restrictions.in((String)"id", (Object[])userIds)).list();
        if (userIds.length != users.size()) {
            throw new JbpmException("not all users were found: " + Arrays.toString(userIds));
        }
        return users;
    }

    @Override
    public List<User> findUsers() {
        return this.session.createCriteria(UserImpl.class).list();
    }

    @Override
    public void deleteUser(String userId) {
        User user = this.findUserById(userId);
        List memberships = this.session.createCriteria(MembershipImpl.class).add((Criterion)Restrictions.eq((String)"user", (Object)user)).list();
        for (MembershipImpl membership : memberships) {
            this.session.delete((Object)membership);
        }
        this.session.delete((Object)user);
    }

    @Override
    public String createGroup(String groupName, String groupType, String parentGroupId) {
        GroupImpl group = new GroupImpl();
        String groupId = groupType != null ? groupType + "." + groupName : groupName;
        group.setId(groupId);
        long dbid = EnvironmentImpl.getFromCurrent(DbidGenerator.class).getNextId();
        group.setDbid(dbid);
        group.setName(groupName);
        group.setType(groupType);
        if (parentGroupId != null) {
            GroupImpl parentGroup = this.findGroupById(parentGroupId);
            group.setParent(parentGroup);
        }
        this.session.save((Object)group);
        return group.getId();
    }

    @Override
    public List<User> findUsersByGroup(String groupId) {
        return this.session.createCriteria(MembershipImpl.class).createAlias("group", "g").add((Criterion)Restrictions.eq((String)"g.id", (Object)groupId)).setProjection((Projection)Projections.property((String)"user")).list();
    }

    @Override
    public GroupImpl findGroupById(String groupId) {
        return (GroupImpl)this.session.createCriteria(GroupImpl.class).add((Criterion)Restrictions.eq((String)"id", (Object)groupId)).uniqueResult();
    }

    @Override
    public List<Group> findGroupsByUserAndGroupType(String userId, String groupType) {
        return this.session.createQuery("select distinct m.group from " + MembershipImpl.class.getName() + " as m where m.user.id = :userId" + " and m.group.type = :groupType").setString("userId", userId).setString("groupType", groupType).list();
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.session.createQuery("select distinct m.group from " + MembershipImpl.class.getName() + " as m where m.user.id = :userId").setString("userId", userId).list();
    }

    public List<Group> findGroups() {
        return this.session.createCriteria(GroupImpl.class).list();
    }

    @Override
    public void deleteGroup(String groupId) {
        GroupImpl group = this.findGroupById(groupId);
        List memberships = this.session.createCriteria(MembershipImpl.class).add((Criterion)Restrictions.eq((String)"group", (Object)group)).list();
        for (MembershipImpl membership : memberships) {
            this.session.delete((Object)membership);
        }
        this.session.delete((Object)group);
    }

    @Override
    public void createMembership(String userId, String groupId, String role) {
        User user = this.findUserById(userId);
        if (user == null) {
            throw new JbpmException("user " + userId + " doesn't exist");
        }
        GroupImpl group = this.findGroupById(groupId);
        if (group == null) {
            throw new JbpmException("group " + groupId + " doesn't exist");
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setUser(user);
        membership.setGroup(group);
        membership.setRole(role);
        long dbid = EnvironmentImpl.getFromCurrent(DbidGenerator.class).getNextId();
        membership.setDbid(dbid);
        this.session.save((Object)membership);
    }

    @Override
    public void deleteMembership(String userId, String groupId, String role) {
        MembershipImpl membership = (MembershipImpl)this.session.createCriteria(MembershipImpl.class).createAlias("user", "u").createAlias("group", "g").add((Criterion)Restrictions.eq((String)"u.id", (Object)userId)).add((Criterion)Restrictions.eq((String)"g.id", (Object)groupId)).uniqueResult();
        this.session.delete((Object)membership);
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

