/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.filters.IsJsonFilter;
import org.mule.module.json.transformers.AbstractJsonTransformer;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToJson
extends AbstractJsonTransformer {
    protected final transient Log logger = LogFactory.getLog(ObjectToJson.class);
    private Map<Class<?>, Class<?>> serializationMixins = new HashMap();
    protected Class<?> sourceClass;
    private boolean handleException = false;
    private IsJsonFilter isJsonFilter = new IsJsonFilter();

    public ObjectToJson() {
        this.setReturnDataType(DataTypeFactory.JSON_STRING);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getSourceClass() != null) {
            this.sourceTypes.clear();
            this.registerSourceType(DataTypeFactory.create(this.getSourceClass()));
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.getMixins().entrySet()) {
            this.getMapper().getSerializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<?>> entry : this.serializationMixins.entrySet()) {
            this.getMapper().getSerializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object src = message.getPayload();
        if (src instanceof String && this.isJsonFilter.accept(src)) {
            return src;
        }
        if (message.getExceptionPayload() != null && this.isHandleException()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found exception with null payload");
            }
            src = this.getException(message.getExceptionPayload().getException());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.getMapper().writeValue((OutputStream)baos, src);
        }
        catch (IOException e) {
            throw new TransformerException(this, (Throwable)e);
        }
        if (this.returnType.equals(byte[].class)) {
            return baos.toByteArray();
        }
        return baos.toString();
    }

    private Exception getException(Throwable t) {
        Exception returnValue = null;
        ArrayList<Throwable> causeStack = new ArrayList<Throwable>();
        for (Throwable tempCause = t; tempCause != null; tempCause = tempCause.getCause()) {
            causeStack.add(tempCause);
        }
        for (int i = causeStack.size() - 1; i >= 0; --i) {
            Throwable tempCause = (Throwable)causeStack.get(i);
            if (i == causeStack.size()) {
                returnValue = new Exception(tempCause.getMessage());
                returnValue.setStackTrace(tempCause.getStackTrace());
                continue;
            }
            returnValue = new Exception(tempCause.getMessage(), returnValue);
            returnValue.setStackTrace(tempCause.getStackTrace());
        }
        return returnValue;
    }

    public boolean isHandleException() {
        return this.handleException;
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public Map<Class<?>, Class<?>> getSerializationMixins() {
        return this.serializationMixins;
    }

    public void setSerializationMixins(Map<Class<?>, Class<?>> serializationMixins) {
        this.serializationMixins = serializationMixins;
    }
}

