/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.atom;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import javax.activation.MimeType;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.lifecycle.Callable;
import org.mule.api.transport.OutputHandler;
import org.mule.component.DefaultJavaComponent;
import org.mule.module.atom.server.MuleRequestContext;
import org.mule.object.SingletonObjectFactory;

public class AbderaServiceComponent
extends DefaultJavaComponent {
    public static final String EVENT_CONTEXT = "_muleEventContext";
    protected static final transient Log logger = LogFactory.getLog(AbderaServiceComponent.class);
    private Provider provider;

    public AbderaServiceComponent() {
        this.setObjectFactory(new SingletonObjectFactory(new AbderaCallable(this)));
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
        provider.init(Abdera.getInstance(), new HashMap());
    }

    public static final class AbderaCallable
    implements Callable {
        private final AbderaServiceComponent abderaServiceComponent;

        public AbderaCallable(AbderaServiceComponent abderaServiceComponent) {
            this.abderaServiceComponent = abderaServiceComponent;
        }

        public Object onCall(MuleEventContext event) throws MuleException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)event.getMessageAsString());
            }
            MuleMessage msg = event.getMessage();
            IRI baseIri = this.initBaseUri(event.getEndpointURI());
            String contextPath = msg.getInboundProperty("http.request", "");
            Provider provider = this.abderaServiceComponent.getProvider();
            MuleRequestContext reqcontext = new MuleRequestContext(provider, event, msg, contextPath, baseIri);
            reqcontext.setAttribute(RequestContext.Scope.REQUEST, AbderaServiceComponent.EVENT_CONTEXT, event);
            FilterChain chain = new FilterChain(provider, (RequestContext)reqcontext);
            try {
                return this.output(msg, chain.next((RequestContext)reqcontext), event.getMuleContext());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private IRI initBaseUri(EndpointURI endpointURI) {
            String iri = endpointURI.toString();
            if (!iri.endsWith("/")) {
                iri = iri + "/";
            }
            return new IRI(iri);
        }

        private MuleMessage output(MuleMessage request, final ResponseContext context, MuleContext muleContext) throws IOException {
            String[] names;
            MimeType ct;
            OutputHandler payload = new OutputHandler(){

                public void write(MuleEvent event, OutputStream out) throws IOException {
                    if (context.hasEntity()) {
                        context.writeTo(out);
                        out.flush();
                    }
                }
            };
            DefaultMuleMessage response = new DefaultMuleMessage(payload, muleContext);
            response.setOutboundProperty("http.status", context.getStatus());
            long cl = context.getContentLength();
            String cc = context.getCacheControl();
            if (cl > -1L) {
                response.setOutboundProperty("Content-Length", Long.toString(cl));
            }
            if (cc != null && cc.length() > 0) {
                response.setOutboundProperty("Cache-Control", cc);
            }
            if ((ct = context.getContentType()) != null) {
                response.setOutboundProperty("Content-Type", ct.toString());
            }
            for (String name : names = context.getHeaderNames()) {
                Object[] headers;
                for (Object value : headers = context.getHeaders(name)) {
                    if (value instanceof Date) {
                        throw new RuntimeException();
                    }
                    response.setOutboundProperty(name, value.toString());
                }
            }
            return response;
        }
    }
}

