/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.http;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import org.scribe.http.Request;

public class HttpConnectionWrapper {
    public static Request wrap(HttpURLConnection connection) {
        Request result = new Request(Request.Verb.valueOf(connection.getRequestMethod()), connection.getURL().toExternalForm());
        for (String header : connection.getHeaderFields().keySet()) {
            result.addHeader(header, connection.getHeaderField(header));
        }
        String body = HttpConnectionWrapper.getRequestBody(connection);
        if (body != null && !body.equals("")) {
            for (String pair : body.split("&")) {
                String[] values = pair.split("=");
                result.addBodyParameter(values[0], values[1]);
            }
        }
        return result;
    }

    private static String getRequestBody(HttpURLConnection request) {
        try {
            int read;
            char[] buffer = new char[65536];
            StringBuilder out = new StringBuilder();
            InputStreamReader in = new InputStreamReader(request.getInputStream(), "UTF-8");
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
            return out.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to access request inputStream", ioe);
        }
    }
}

