/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.scribe.encoders.URL;
import org.scribe.http.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    private static final String CONTENT_LENGTH = "Content-Length";
    private String url;
    private Verb verb;
    private Map<String, String> bodyParams;
    private Map<String, String> headers;
    private String payload = null;

    public Request(Verb verb, String url) {
        this.verb = verb;
        this.url = url;
        this.bodyParams = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
    }

    public Response send() {
        try {
            return this.doSend();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problems while creating connection", ioe);
        }
    }

    Response doSend() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new java.net.URL(this.url).openConnection();
        connection.setRequestMethod(this.verb.name());
        this.addHeaders(connection);
        if (this.verb.equals((Object)Verb.PUT) || this.verb.equals((Object)Verb.POST)) {
            this.addBody(connection, this.getBodyContents());
        }
        return new Response(connection);
    }

    void addHeaders(HttpURLConnection conn) {
        for (String key : this.headers.keySet()) {
            conn.setRequestProperty(key, this.headers.get(key));
        }
    }

    void addBody(HttpURLConnection conn, String content) throws IOException {
        conn.setRequestProperty(CONTENT_LENGTH, String.valueOf(content.getBytes().length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(content.getBytes());
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addBodyParameter(String key, String value) {
        this.bodyParams.put(key, value);
    }

    public void addPayload(String payload) {
        this.payload = payload;
    }

    public Set<Map.Entry<String, String>> getQueryStringParams() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String query = new java.net.URL(this.url).getQuery();
            if (query != null) {
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    params.put(pair[0], pair[1]);
                }
            }
            return params.entrySet();
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Malformed URL", mue);
        }
    }

    public Set<Map.Entry<String, String>> getBodyParams() {
        return this.bodyParams.entrySet();
    }

    public String getUrl() {
        return this.url;
    }

    public String getSanitizedUrl() {
        return this.url.replaceAll("\\?.*", "").replace("\\:\\d{4}", "");
    }

    public String getBodyContents() {
        return this.payload != null ? this.payload : URL.queryString(this.bodyParams).replaceFirst("\\?", "");
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Verb {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

