/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.module.management.agent.ClassloaderSwitchingMBeanWrapper;
import org.mule.module.management.agent.JmxManagementException;
import org.mule.module.management.agent.WrapperManagerAgent;
import org.mule.module.management.i18n.ManagementMessages;
import org.mule.module.management.mbean.ConnectorService;
import org.mule.module.management.mbean.ConnectorServiceMBean;
import org.mule.module.management.mbean.EndpointService;
import org.mule.module.management.mbean.EndpointServiceMBean;
import org.mule.module.management.mbean.ModelService;
import org.mule.module.management.mbean.ModelServiceMBean;
import org.mule.module.management.mbean.MuleConfigurationService;
import org.mule.module.management.mbean.MuleConfigurationServiceMBean;
import org.mule.module.management.mbean.MuleService;
import org.mule.module.management.mbean.MuleServiceMBean;
import org.mule.module.management.mbean.ServiceService;
import org.mule.module.management.mbean.ServiceServiceMBean;
import org.mule.module.management.mbean.StatisticsService;
import org.mule.module.management.mbean.StatisticsServiceMBean;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;
import org.mule.module.management.support.SimplePasswordJmxAuthenticator;
import org.mule.transport.AbstractConnector;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxAgent
extends AbstractAgent {
    public static final String NAME = "jmx-agent";
    public static final String DEFAULT_REMOTING_URI = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
    public static final Map<String, String> DEFAULT_CONNECTOR_SERVER_PROPERTIES;
    public static final String DEFAULT_JMX_AUTHENTICATOR;
    protected static final Log logger;
    protected boolean locateServer = true;
    protected boolean containerMode = true;
    private boolean createServer = false;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private Map<String, Object> connectorServerProperties = null;
    private boolean enableStatistics = true;
    private final AtomicBoolean serverCreated = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    private Registry rmiRegistry;
    private boolean createRmiRegistry = true;
    private Map<String, String> credentials = new HashMap<String, String>();

    public JmxAgent() {
        super(NAME);
        this.connectorServerProperties = new HashMap<String, String>(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
    }

    @Override
    public String getDescription() {
        if (this.connectorServerUrl != null) {
            return this.name + ": " + this.connectorServerUrl;
        }
        return "JMX Agent";
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.initialized.get()) {
            return;
        }
        this.containerMode = this.muleContext.getConfiguration().isContainerMode();
        try {
            Object agent = this.muleContext.getRegistry().lookupObject(this.getClass());
            if (agent == this && this.initialized.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Found an existing JMX agent in the registry, we're done here.");
                }
                return;
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.mBeanServer == null && this.createServer) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
            this.serverCreated.set(true);
        }
        if (this.mBeanServer == null && this.locateServer) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer == null) {
            throw new InitialisationException(ManagementMessages.cannotLocateOrCreateServer(), (Initialisable)this);
        }
        if (StringUtils.isBlank((String)this.muleContext.getConfiguration().getId())) {
            throw new IllegalArgumentException("Manager ID is mandatory when running with JmxAgent. Give your Mule configuration a valid ID.");
        }
        try {
            this.muleContext.registerListener(new MuleContextStartedListener());
            this.muleContext.registerListener(new MuleContextStoppedListener());
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.initialized.compareAndSet(false, true);
    }

    protected void initRMI() throws Exception {
        String connectUri;
        String string = connectUri = this.connectorServerUrl != null ? this.connectorServerUrl : DEFAULT_REMOTING_URI;
        if (connectUri.contains("jmx:rmi")) {
            int i = connectUri.lastIndexOf("rmi://");
            URI uri = new URI(connectUri.substring(i));
            if (this.rmiRegistry == null) {
                try {
                    if (this.isCreateRmiRegistry()) {
                        try {
                            this.rmiRegistry = LocateRegistry.createRegistry(uri.getPort());
                        }
                        catch (ExportException e) {
                            logger.info((Object)("Registry on " + uri + " already bound. Attempting to use that instead"));
                            this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                        }
                    } else {
                        this.rmiRegistry = LocateRegistry.getRegistry(uri.getHost(), uri.getPort());
                    }
                }
                catch (RemoteException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
            }
        }
    }

    @Override
    public void start() throws MuleException {
        try {
            this.initRMI();
            logger.info((Object)"Creating and starting JMX agent connector Server");
            if (this.connectorServerUrl != null) {
                JMXServiceURL url = new JMXServiceURL(this.connectorServerUrl);
                if (this.connectorServerProperties == null) {
                    this.connectorServerProperties = new HashMap<String, String>(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
                }
                if (!this.credentials.isEmpty()) {
                    JMXAuthenticator jmxAuthenticator = (JMXAuthenticator)ClassUtils.instanciateClass(DEFAULT_JMX_AUTHENTICATOR, new Object[0]);
                    ((SimplePasswordJmxAuthenticator)jmxAuthenticator).setCredentials(this.credentials);
                    this.connectorServerProperties.put("jmx.remote.authenticator", jmxAuthenticator);
                }
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.connectorServerProperties, this.mBeanServer);
                this.connectorServer.start();
            }
        }
        catch (ExportException e) {
            throw new JmxManagementException(CoreMessages.failedToStart("Jmx Agent"), (Throwable)e);
        }
        catch (Exception e) {
            throw new JmxManagementException(CoreMessages.failedToStart("Jmx Agent"), (Throwable)e);
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                throw new JmxManagementException(CoreMessages.failedToStop("Jmx Connector"), (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        this.unregisterMBeansIfNecessary();
        if (this.serverCreated.get()) {
            MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
        }
        this.mBeanServer = null;
        this.serverCreated.compareAndSet(true, false);
        this.initialized.set(false);
    }

    protected void registerWrapperService() throws MuleException {
        WrapperManagerAgent wmAgent = new WrapperManagerAgent();
        if (this.muleContext.getRegistry().lookupAgent(wmAgent.getName()) == null) {
            this.muleContext.getRegistry().registerAgent(wmAgent);
        }
    }

    protected void registerStatisticsService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(String.format("%s:%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "type=Statistics,name=AllStatistics"));
        StatisticsService service = new StatisticsService();
        service.setMuleContext(this.muleContext);
        service.setEnabled(this.isEnableStatistics());
        ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, StatisticsServiceMBean.class, this.muleContext.getExecutionClassLoader());
        logger.debug((Object)("Registering statistics with name: " + on));
        this.mBeanServer.registerMBean(mBean, on);
    }

    protected void registerModelServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        for (Model model : this.muleContext.getRegistry().lookupObjects(Model.class)) {
            ModelService service = new ModelService(model);
            String rawName = service.getName() + "(" + service.getType() + ")";
            String name = this.jmxSupport.escape(rawName);
            String jmxName = String.format("%s:%s%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "type=Model,name=", name);
            ObjectName on = this.jmxSupport.getObjectName(jmxName);
            ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, ModelServiceMBean.class, this.muleContext.getExecutionClassLoader());
            logger.debug((Object)("Registering model with name: " + on));
            this.mBeanServer.registerMBean(mBean, on);
        }
    }

    protected void registerMuleService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(String.format("%s:%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "name=MuleContext"));
        if (this.muleContext.getConfiguration().isContainerMode() && this.mBeanServer.isRegistered(on)) {
            return;
        }
        MuleService service = new MuleService(this.muleContext);
        ClassloaderSwitchingMBeanWrapper serviceMBean = new ClassloaderSwitchingMBeanWrapper(service, MuleServiceMBean.class, this.muleContext.getExecutionClassLoader());
        logger.debug((Object)("Registering mule with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
    }

    protected void registerConfigurationService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(String.format("%s:%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "name=Configuration"));
        MuleConfigurationService service = new MuleConfigurationService(this.muleContext.getConfiguration());
        ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, MuleConfigurationServiceMBean.class, this.muleContext.getExecutionClassLoader());
        logger.debug((Object)("Registering configuration with name: " + on));
        this.mBeanServer.registerMBean(mBean, on);
    }

    protected void registerServiceServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        for (Service service : this.muleContext.getRegistry().lookupObjects(Service.class)) {
            String rawName = service.getName();
            String name = this.jmxSupport.escape(rawName);
            String jmxName = String.format("%s:%s%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "type=Service,name=", name);
            ObjectName on = this.jmxSupport.getObjectName(jmxName);
            ServiceService serviceMBean = new ServiceService(rawName, this.muleContext);
            ClassloaderSwitchingMBeanWrapper wrapper = new ClassloaderSwitchingMBeanWrapper(serviceMBean, ServiceServiceMBean.class, this.muleContext.getExecutionClassLoader());
            logger.debug((Object)("Registering service with name: " + on));
            this.mBeanServer.registerMBean(wrapper, on);
        }
    }

    protected void registerEndpointServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        for (Connector connector : this.muleContext.getRegistry().lookupObjects(Connector.class)) {
            if (connector instanceof AbstractConnector) {
                for (MessageReceiver messageReceiver : ((AbstractConnector)connector).getReceivers().values()) {
                    EndpointService service = new EndpointService(messageReceiver);
                    String fullName = this.buildFullyQualifiedEndpointName(service, connector);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Attempting to register service with name: " + fullName));
                    }
                    ObjectName on = this.jmxSupport.getObjectName(fullName);
                    ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, EndpointServiceMBean.class, this.muleContext.getExecutionClassLoader());
                    this.mBeanServer.registerMBean(mBean, on);
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Registered Endpoint Service with name: " + on));
                }
                continue;
            }
            logger.warn((Object)("Connector: " + connector + " is not an istance of AbstractConnector, cannot obtain Endpoint MBeans from it"));
        }
    }

    protected String buildFullyQualifiedEndpointName(EndpointServiceMBean mBean, Connector connector) {
        String rawName = this.jmxSupport.escape(mBean.getName());
        StringBuilder fullName = new StringBuilder(128);
        fullName.append(this.jmxSupport.getDomainName(this.muleContext, !this.containerMode));
        fullName.append(":type=Endpoint,service=");
        fullName.append(this.jmxSupport.escape(mBean.getComponentName()));
        fullName.append(",connector=");
        fullName.append(connector.getName());
        fullName.append(",name=");
        fullName.append(rawName);
        return fullName.toString();
    }

    protected void registerConnectorServices() throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        for (Connector connector : this.muleContext.getRegistry().lookupObjects(Connector.class)) {
            ConnectorService service = new ConnectorService(connector);
            String rawName = service.getName();
            String name = this.jmxSupport.escape(rawName);
            String jmxName = String.format("%s:%s%s", this.jmxSupport.getDomainName(this.muleContext, !this.containerMode), "type=Connector,name=", name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to register service with name: " + jmxName));
            }
            ObjectName oName = this.jmxSupport.getObjectName(jmxName);
            ClassloaderSwitchingMBeanWrapper mBean = new ClassloaderSwitchingMBeanWrapper(service, ConnectorServiceMBean.class, this.muleContext.getExecutionClassLoader());
            this.mBeanServer.registerMBean(mBean, oName);
            logger.info((Object)("Registered Connector Service with name " + oName));
        }
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map<String, Object> getConnectorServerProperties() {
        return this.connectorServerProperties;
    }

    public void setConnectorServerProperties(Map<String, Object> connectorServerProperties) {
        this.connectorServerProperties = connectorServerProperties;
    }

    public JmxSupportFactory getJmxSupportFactory() {
        return this.jmxSupportFactory;
    }

    public void setJmxSupportFactory(JmxSupportFactory jmxSupportFactory) {
        this.jmxSupportFactory = jmxSupportFactory;
    }

    public void setCredentials(Map<String, String> newCredentials) {
        this.credentials.clear();
        if (newCredentials != null && !newCredentials.isEmpty()) {
            this.credentials.putAll(newCredentials);
        }
    }

    protected void unregisterMBeansIfNecessary() {
        this.unregisterMBeansIfNecessary(false);
    }

    protected void unregisterMBeansIfNecessary(boolean containerMode) {
        if (this.mBeanServer == null) {
            return;
        }
        try {
            String domain = this.jmxSupport.getDomainName(this.muleContext, false);
            ObjectName query = this.jmxSupport.getObjectName(domain + ":*");
            Set<ObjectName> mbeans = this.mBeanServer.queryNames(query, null);
            while (!mbeans.isEmpty()) {
                ObjectName name = mbeans.iterator().next();
                try {
                    if (!containerMode || !"name=MuleContext".equals(name.getCanonicalKeyPropertyListString())) {
                        this.mBeanServer.unregisterMBean(name);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)String.format("Failed to unregister MBean: %s. Error is: %s", name, e.getMessage()));
                }
                mbeans = this.mBeanServer.queryNames(query, null);
                if (!containerMode) continue;
                mbeans.remove(this.jmxSupport.getObjectName(String.format("%s:%s", domain, "name=MuleContext")));
            }
        }
        catch (MalformedObjectNameException e) {
            logger.warn((Object)"Failed to create ObjectName query", (Throwable)e);
        }
    }

    public Registry getRmiRegistry() {
        return this.rmiRegistry;
    }

    public void setRmiRegistry(Registry rmiRegistry) {
        this.rmiRegistry = rmiRegistry;
    }

    public boolean isCreateRmiRegistry() {
        return this.createRmiRegistry;
    }

    public void setCreateRmiRegistry(boolean createRmiRegistry) {
        this.createRmiRegistry = createRmiRegistry;
    }

    static {
        DEFAULT_JMX_AUTHENTICATOR = SimplePasswordJmxAuthenticator.class.getName();
        logger = LogFactory.getLog(JmxAgent.class);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("jmx.remote.jndi.rebind", "true");
        DEFAULT_CONNECTOR_SERVER_PROPERTIES = Collections.unmodifiableMap(props);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MuleContextStoppedListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        protected MuleContextStoppedListener() {
        }

        @Override
        public void onNotification(MuleContextNotification notification) {
            if (notification.getAction() == 106) {
                boolean containerMode = notification.getMuleContext().getConfiguration().isContainerMode();
                JmxAgent.this.unregisterMBeansIfNecessary(containerMode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MuleContextStartedListener
    implements MuleContextNotificationListener<MuleContextNotification> {
        protected MuleContextStartedListener() {
        }

        @Override
        public void onNotification(MuleContextNotification notification) {
            if (notification.getAction() == 104) {
                try {
                    JmxAgent.this.registerWrapperService();
                    JmxAgent.this.registerStatisticsService();
                    JmxAgent.this.registerMuleService();
                    JmxAgent.this.registerConfigurationService();
                    JmxAgent.this.registerModelServices();
                    JmxAgent.this.registerServiceServices();
                    JmxAgent.this.registerEndpointServices();
                    JmxAgent.this.registerConnectorServices();
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.objectFailedToInitialise("MBeans"), (Throwable)e);
                }
            }
        }
    }
}

