/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.module.management.mbean.RouterStats;
import org.mule.module.management.mbean.ServiceStatsMBean;

public class ServiceStats
implements ServiceStatsMBean,
MBeanRegistration {
    private static Log LOGGER = LogFactory.getLog(ServiceStats.class);
    private MBeanServer server;
    private ObjectName name;
    private ObjectName inboundName;
    private ObjectName outboundName;
    private ServiceStatistics statistics;

    public ServiceStats(ServiceStatistics statistics) {
        this.statistics = statistics;
    }

    public void clearStatistics() {
        this.statistics.clear();
    }

    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    public long getAsyncEventsSent() {
        return this.statistics.getAsyncEventsSent();
    }

    public long getAverageExecutionTime() {
        return this.statistics.getAverageExecutionTime();
    }

    public long getAverageQueueSize() {
        return this.statistics.getAverageQueueSize();
    }

    public long getExecutedEvents() {
        return this.statistics.getExecutedEvents();
    }

    public long getExecutionErrors() {
        return this.statistics.getExecutionErrors();
    }

    public long getFatalErrors() {
        return this.statistics.getFatalErrors();
    }

    public long getMaxExecutionTime() {
        return this.statistics.getMaxExecutionTime();
    }

    public long getMaxQueueSize() {
        return this.statistics.getMaxQueueSize();
    }

    public long getMinExecutionTime() {
        return this.statistics.getMinExecutionTime();
    }

    public String getName() {
        return this.statistics.getName();
    }

    public long getQueuedEvents() {
        return this.statistics.getQueuedEvents();
    }

    public long getReplyToEventsSent() {
        return this.statistics.getReplyToEventsSent();
    }

    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    public long getSyncEventsSent() {
        return this.statistics.getSyncEventsSent();
    }

    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    public long getTotalEventsSent() {
        return this.statistics.getTotalEventsSent();
    }

    public long getTotalExecutionTime() {
        return this.statistics.getTotalExecutionTime();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.name = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        try {
            RouterStatistics os;
            RouterStatistics is = this.statistics.getInboundRouterStat();
            if (is != null) {
                this.inboundName = new ObjectName(this.name.getDomain() + ":type=org.mule.Statistics,service=" + this.statistics.getName() + ",router=inbound");
                if (this.server.isRegistered(this.inboundName)) {
                    this.server.unregisterMBean(this.inboundName);
                }
                this.server.registerMBean(new RouterStats(is), this.inboundName);
            }
            if ((os = this.statistics.getOutboundRouterStat()) != null) {
                this.outboundName = new ObjectName(this.name.getDomain() + ":type=org.mule.Statistics,service=" + this.statistics.getName() + ",router=outbound");
                if (this.server.isRegistered(this.outboundName)) {
                    this.server.unregisterMBean(this.outboundName);
                }
                this.server.registerMBean(new RouterStats(os), this.outboundName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering MBean", (Throwable)e);
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        try {
            if (this.server.isRegistered(this.inboundName)) {
                this.server.unregisterMBean(this.inboundName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ServiceStats child " + this.inboundName.getCanonicalName()), (Throwable)ex);
        }
        try {
            if (this.server.isRegistered(this.outboundName)) {
                this.server.unregisterMBean(this.outboundName);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Error unregistering ServiceStats child " + this.inboundName.getCanonicalName()), (Throwable)ex);
        }
    }

    public ObjectName getRouterInbound() {
        return this.inboundName;
    }

    public ObjectName getRouterOutbound() {
        return this.outboundName;
    }
}

