/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.tck.AbstractMuleTestCase;

public class DefaultExceptionStrategyTestCase
extends AbstractMuleTestCase {
    public void testExceptions() throws Exception {
        InstrumentedExceptionStrategy strategy = new InstrumentedExceptionStrategy();
        strategy.setMuleContext(muleContext);
        strategy.handleException(new IllegalArgumentException("boom"));
        DefaultExceptionStrategyTestCase.assertEquals((int)1, (int)strategy.getCount());
    }

    public void testExceptionNotifications() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger notificationCount = new AtomicInteger(0);
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                if (notification.getAction() == 1101) {
                    Assert.assertEquals((String)"exception", (String)notification.getActionName());
                    Assert.assertEquals((String)"Wrong info type", (String)"error", (String)notification.getType());
                    notificationCount.incrementAndGet();
                    latch.countDown();
                }
            }
        });
        InstrumentedExceptionStrategy strategy = new InstrumentedExceptionStrategy();
        strategy.setMuleContext(muleContext);
        strategy.handleException(new IllegalArgumentException("boom"));
        latch.await(2000L, TimeUnit.MILLISECONDS);
        DefaultExceptionStrategyTestCase.assertEquals((int)1, (int)notificationCount.get());
    }

    private static class InstrumentedExceptionStrategy
    extends DefaultSystemExceptionStrategy {
        private volatile int count = 0;

        private InstrumentedExceptionStrategy() {
        }

        public void handleException(Exception exception) {
            ++this.count;
            super.handleException(exception);
        }

        public int getCount() {
            return this.count;
        }
    }
}

