/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.sql.Timestamp;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractMuleTestCase;

public class ExpressionManagerTestCase
extends AbstractMuleTestCase {
    public void testManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object o = muleContext.getExpressionManager().evaluate("function:uuid", (MuleMessage)message);
        ExpressionManagerTestCase.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("function:now", (MuleMessage)message);
        ExpressionManagerTestCase.assertNotNull((Object)o);
        ExpressionManagerTestCase.assertTrue((boolean)(o instanceof Timestamp));
    }

    public void testRegistration() throws Exception {
        try {
            muleContext.getExpressionManager().registerEvaluator(null);
            ExpressionManagerTestCase.fail((String)"null extractor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ExpressionManagerTestCase.assertNull((Object)muleContext.getExpressionManager().unregisterEvaluator(null));
    }

    public void testValidator() throws Exception {
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://${bean:user}:${bean:password}@${header:host}:${header:port}/foo/bar"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("${bean:user}"));
        ExpressionManagerTestCase.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[bean:user]"));
        ExpressionManagerTestCase.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:#[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("{bean:user}"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("#{bean:user"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("user"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user:#[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:##[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]]:##[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        ExpressionManagerTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:#[[bean:password]@#[header:host]:#[header:port]/foo/bar"));
        ExpressionManagerTestCase.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("http://#[bean:user]:#[#bean:password]@#[header:host]:#[header:port]/foo/bar"));
    }

    public void testParsing() {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"test", muleContext);
        msg.setOutboundProperty("user", (Object)"vasya");
        msg.setOutboundProperty("password", (Object)"pupkin");
        msg.setOutboundProperty("host", (Object)"example.com");
        msg.setOutboundProperty("port", (Object)"12345");
        String result = muleContext.getExpressionManager().parse("http://#[header:user]:#[header:password]@#[header:host]:#[header:port]/foo/bar", (MuleMessage)msg);
        ExpressionManagerTestCase.assertNotNull((Object)result);
        ExpressionManagerTestCase.assertEquals((String)"http://vasya:pupkin@example.com:12345/foo/bar", (String)result);
    }
}

