/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.beans.ExceptionListener;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;

public class AsyncInterceptingMessageProcessorTestCase
extends AbstractMuleTestCase
implements ExceptionListener {
    protected MessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    protected Exception exceptionThrown;
    protected Latch latch = new Latch();

    public AsyncInterceptingMessageProcessorTestCase() {
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.messageProcessor = this.createAsyncInterceptingMessageProcessor(this.target);
    }

    public void testProcessSync() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", (ImmutableEndpoint)AsyncInterceptingMessageProcessorTestCase.getTestOutboundEndpoint("", "test://test?exchangePattern=request-response"));
        MuleEvent result = this.messageProcessor.process(event);
        AsyncInterceptingMessageProcessorTestCase.assertSame((Object)event, (Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertSame((Object)event, (Object)result);
    }

    public void testProcessAsync() throws Exception {
        MuleEvent event = AsyncInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", (ImmutableEndpoint)AsyncInterceptingMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        MuleEvent result = this.messageProcessor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        AsyncInterceptingMessageProcessorTestCase.assertNotNull((Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        AsyncInterceptingMessageProcessorTestCase.assertEquals((String)event.getMessageAsString(), (String)this.target.sensedEvent.getMessageAsString());
        AsyncInterceptingMessageProcessorTestCase.assertNull((Object)result);
        AsyncInterceptingMessageProcessorTestCase.assertNull((Object)this.exceptionThrown);
    }

    protected AsyncInterceptingMessageProcessor createAsyncInterceptingMessageProcessor(MessageProcessor listener) throws Exception {
        AsyncInterceptingMessageProcessor mp = new AsyncInterceptingMessageProcessor((WorkManagerSource)new TestWorkManagerSource(), true);
        mp.setListener(listener);
        return mp;
    }

    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestWorkManagerSource
    implements WorkManagerSource {
        TestWorkManagerSource() {
        }

        public WorkManager getWorkManager() throws MuleException {
            return muleContext.getWorkManager();
        }
    }

    class TestListener
    implements MessageProcessor {
        MuleEvent sensedEvent;

        TestListener() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.sensedEvent = event;
            AsyncInterceptingMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

