/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.AbstractMuleTestCase;

public class WildcardFilterTestCase
extends AbstractMuleTestCase {
    public void testWildcardFilterNoPattern() {
        WildcardFilter filter = new WildcardFilter();
        WildcardFilterTestCase.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("* brown fox");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        WildcardFilterTestCase.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    public void testWildcardFilterPostfix() {
        WildcardFilter filter = new WildcardFilter("The quick *");
        WildcardFilterTestCase.assertNotNull((Object)filter.getPattern());
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick *"));
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"he quick brown fox") ? 1 : 0) != 0);
    }

    public void testWildcardFilterPrefix() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown fox");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"* brown fox"));
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"The quick brown fo") ? 1 : 0) != 0);
    }

    public void testWildcardFilterExactMatch() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("fox");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"fox"));
        filter.setPattern("");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)""));
    }

    public void testWildcardFilterPrePost() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown *");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"* brown fox"));
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("**");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern("*w*");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern("*");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern("*.*");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"test.xml"));
        filter.setPattern("*.txt");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"test.txt"));
    }

    public void testWildcardFilterMultiplePatterns() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown*, The*");
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)" brown fox"));
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quickbrown fox"));
        filter.setPattern("* if, The*");
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"What The!") ? 1 : 0) != 0);
        WildcardFilterTestCase.assertTrue((!filter.accept((Object)"simplify") ? 1 : 0) != 0);
    }

    public void testWildcardFilterCasesensitive() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown fox");
        WildcardFilterTestCase.assertFalse((boolean)filter.accept((Object)"The quick Brown fox"));
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"* brown fox"));
        filter.setCaseSensitive(false);
        WildcardFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick Brown fox"));
    }
}

