/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.transport.jdbc.i18n.JdbcMessages;

public class JdbcTransaction
extends AbstractSingleResourceTransaction {
    public JdbcTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof DataSource) || !(resource instanceof Connection)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources("javax.sql.DataSource/java.sql.Connection"));
        }
        Connection con = (Connection)resource;
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TransactionException(JdbcMessages.transactionSetAutoCommitFailed(), (Throwable)e);
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        if (this.resource == null) {
            this.logger.warn((Object)CoreMessages.commitTxButNoResource(this));
            return;
        }
        try {
            ((Connection)this.resource).commit();
            ((Connection)this.resource).close();
        }
        catch (SQLException e) {
            throw new TransactionException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        if (this.resource == null) {
            this.logger.warn((Object)CoreMessages.rollbackTxButNoResource(this));
            return;
        }
        try {
            ((Connection)this.resource).rollback();
            ((Connection)this.resource).close();
        }
        catch (SQLException e) {
            throw new TransactionRollbackException(CoreMessages.transactionRollbackFailed(), (Throwable)e);
        }
    }
}

