/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.dsl.routers;

import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class ContentBasedRouter
extends AbstractOutboundRouter {
    public MuleEvent route(MuleEvent theEvent) throws MessagingException {
        MuleMessage message = theEvent.getMessage();
        for (MessageProcessor target : this.routes) {
            if (!this.isMatch(message)) continue;
            MuleEvent event = RequestContext.cloneAndUpdateEventEndpoint(theEvent, target);
            try {
                return target.process(event);
            }
            catch (MuleException e) {
                throw new MessagingException(e.getI18nMessage(), event, (Throwable)e);
            }
        }
        throw new RuntimeException("Event not processed");
    }

    public boolean isMatch(MuleMessage message) throws MessagingException {
        for (MessageProcessor target : this.routes) {
            if (target instanceof ImmutableEndpoint) {
                ImmutableEndpoint endpoint = (ImmutableEndpoint)((Object)target);
                if (endpoint.getFilter() != null && !endpoint.getFilter().accept(message)) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

