/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.filters.WildcardFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static Object getPropertyWithScope(String expression, MuleMessage msg) {
        return ExpressionUtils.getPropertyWithScope(expression, msg, Object.class);
    }

    public static <T> T getPropertyWithScope(String expression, MuleMessage msg, Class<T> type) {
        Object result;
        PropertyScope defaultScope = ExpressionUtils.getScope(expression);
        if (defaultScope != null) {
            expression = expression.substring(defaultScope.getScopeName().length() + 1);
        } else {
            defaultScope = PropertyScope.OUTBOUND;
        }
        if (expression.contains("*")) {
            WildcardFilter filter = new WildcardFilter(expression);
            if (Map.class.isAssignableFrom(type)) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (String name : msg.getPropertyNames(defaultScope)) {
                    if (!filter.accept(name)) continue;
                    props.put(name, msg.getProperty(name, defaultScope));
                }
                return (T)ExpressionUtils.returnMap(props, defaultScope);
            }
            if (List.class.isAssignableFrom(type)) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (String name : msg.getPropertyNames(defaultScope)) {
                    if (!filter.accept(name)) continue;
                    values.add(msg.getProperty(name, defaultScope));
                }
                return (T)ExpressionUtils.returnList(values, defaultScope);
            }
            throw new IllegalArgumentException("Type specified is not a collection type but '*' was specified for all properties. Type is: " + type);
        }
        if (Map.class.isAssignableFrom(type)) {
            String[] names = expression.split(",");
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String name : names) {
                Object value;
                boolean required = true;
                PropertyScope scope = ExpressionUtils.getScope(name = name.trim());
                if (scope != null) {
                    name = name.substring(scope.getScopeName().length() + 1);
                } else {
                    scope = defaultScope;
                }
                if (name.endsWith("?")) {
                    name = name.substring(0, name.length() - "?".length());
                    required = false;
                }
                if ((value = msg.getProperty(name, scope)) == null && required) {
                    throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull("headers", scope.getScopeName() + ":" + name));
                }
                if (value == null) continue;
                props.put(name, value);
            }
            return (T)ExpressionUtils.returnMap(props, defaultScope);
        }
        if (List.class.isAssignableFrom(type)) {
            String[] names = expression.split(",");
            ArrayList<Object> values = new ArrayList<Object>();
            for (String name : names) {
                Object value;
                boolean required = true;
                PropertyScope scope = ExpressionUtils.getScope(name = name.trim());
                if (scope != null) {
                    name = name.substring(scope.getScopeName().length() + 1);
                } else {
                    scope = defaultScope;
                }
                if (name.endsWith("?")) {
                    name = name.substring(0, name.length() - "?".length());
                    required = false;
                }
                if ((value = msg.getProperty(name = name.trim(), scope)) == null && required) {
                    throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull("headers-list", scope.getScopeName() + ":" + name));
                }
                if (value == null) continue;
                values.add(value);
            }
            return (T)ExpressionUtils.returnList(values, defaultScope);
        }
        boolean required = true;
        if (expression.endsWith("?")) {
            expression = expression.substring(0, expression.length() - "?".length());
            required = false;
        }
        if ((result = msg.getProperty(expression.trim(), defaultScope)) == null && required) {
            throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull("header", defaultScope.getScopeName() + ":" + expression));
        }
        return result;
    }

    private static Map<String, Object> returnMap(Map<String, Object> props, PropertyScope scope) {
        Map<Object, Object> p;
        Map<Object, Object> map = p = props.size() == 0 ? Collections.emptyMap() : props;
        if (scope.equals(PropertyScope.INBOUND)) {
            p = Collections.unmodifiableMap(p);
        }
        return p;
    }

    private static List<Object> returnList(List<Object> values, PropertyScope scope) {
        List<Object> l;
        List<Object> list = l = values.size() == 0 ? Collections.emptyList() : values;
        if (scope.equals(PropertyScope.INBOUND)) {
            l = Collections.unmodifiableList(l);
        }
        return l;
    }

    private static PropertyScope getScope(String expression) {
        String[] tokens = expression.split(":", 2);
        if (tokens.length == 2) {
            String candidate = tokens[0];
            PropertyScope scope = PropertyScope.get(candidate.toLowerCase());
            if (scope == null) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid property scope.", candidate));
            }
            return scope;
        }
        return null;
    }
}

