/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.TransformingMatchable;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DynamicURIOutboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.util.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringOutboundRouter
extends AbstractOutboundRouter
implements TransformingMatchable {
    protected ExpressionManager expressionManager;
    private List<Transformer> transformers = new LinkedList<Transformer>();
    private Filter filter;
    private boolean useTemplates = true;
    private TemplateParser parser = TemplateParser.createSquareBracesStyleParser();

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    @Override
    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleEvent result;
        MuleMessage message = event.getMessage();
        if (this.routes == null || this.routes.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), event, null);
        }
        MessageProcessor ep = this.getRoute(0, message);
        try {
            result = this.sendRequest(event, message, ep, true);
        }
        catch (RoutingException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(event, ep, (Throwable)e);
        }
        return result;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isMatch(MuleMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        try {
            message.applyTransformers(null, this.transformers);
        }
        catch (MuleException e) {
            throw new RoutingException(CoreMessages.transformFailedBeforeFilter(), message, (MessageProcessor)this.routes.get(0), (Throwable)e);
        }
        return this.getFilter().accept(message);
    }

    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    @Override
    public void addRoute(MessageProcessor target) throws MuleException {
        ImmutableEndpoint endpoint;
        if (!this.useTemplates && target instanceof ImmutableEndpoint && this.parser.isContainsTemplate((endpoint = (ImmutableEndpoint)((Object)target)).getEndpointURI().toString())) {
            this.useTemplates = true;
        }
        super.addRoute(target);
    }

    public MessageProcessor getRoute(int index, MuleMessage message) throws CouldNotRouteOutboundMessageException {
        if (!this.useTemplates) {
            return (MessageProcessor)this.routes.get(index);
        }
        MessageProcessor mp = (MessageProcessor)this.routes.get(index);
        if (!(mp instanceof ImmutableEndpoint)) {
            return (MessageProcessor)this.routes.get(index);
        }
        OutboundEndpoint ep = (OutboundEndpoint)mp;
        String uri = ep.getAddress();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri before parsing is: " + uri));
        }
        HashMap props = new HashMap();
        props.putAll(ep.getProperties());
        for (String propertyKey : message.getOutboundPropertyNames()) {
            Object value = message.getOutboundProperty(propertyKey);
            props.put(propertyKey, value);
        }
        this.propagateMagicProperties(message, message);
        if (!this.parser.isContainsTemplate(uri)) {
            this.logger.debug((Object)"Uri does not contain template(s)");
            return ep;
        }
        String newUriString = this.parser.parse(props, uri);
        if (this.parser.isContainsTemplate(newUriString)) {
            newUriString = this.getMuleContext().getExpressionManager().parse(newUriString, message, true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Uri after parsing is: " + uri));
        }
        try {
            MuleEndpointURI newUri = new MuleEndpointURI(newUriString, this.muleContext);
            EndpointURI endpointURI = ep.getEndpointURI();
            if (endpointURI != null && !newUri.getScheme().equalsIgnoreCase(endpointURI.getScheme())) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.schemeCannotChangeForRouter(ep.getEndpointURI().getScheme(), newUri.getScheme()), message, (MessageProcessor)ep);
            }
            return new DynamicURIOutboundEndpoint(ep, newUri);
        }
        catch (EndpointException e) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.templateCausedMalformedEndpoint(uri, newUriString), message, (MessageProcessor)ep, (Throwable)e);
        }
    }

    public boolean isUseTemplates() {
        return this.useTemplates;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }

    @Override
    public boolean isTransformBeforeMatch() {
        return !this.transformers.isEmpty();
    }
}

